/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.sapphire.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapFactory<K, V> {
    private Filter<Map.Entry<K, V>> filter;
    private K firstKey = null;
    private V firstValue = null;
    private Map<K, V> map = null;
    private boolean exported = false;

    private MapFactory() {
    }

    public static <K, V> Map<K, V> empty() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> singleton(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        return MapFactory.start().add(map).result();
    }

    public static <K, V> MapFactory<K, V> start() {
        return new MapFactory<K, V>();
    }

    public MapFactory<K, V> filter(Filter<Map.Entry<K, V>> filter) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.filter = filter;
        if (this.filter != null) {
            if (this.map != null) {
                Iterator<Map.Entry<K, V>> itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    if (this.filter.allows(itr.next())) continue;
                    itr.remove();
                }
                int size = this.map.size();
                if (size == 1) {
                    Map.Entry<K, V> firstEntry = this.map.entrySet().iterator().next();
                    this.firstKey = firstEntry.getKey();
                    this.firstValue = firstEntry.getValue();
                    this.map = null;
                } else if (size == 0) {
                    this.map = null;
                }
            } else if (this.firstKey != null && !this.filter.allows(new Entry<K, V>(this.firstKey, this.firstValue))) {
                this.firstKey = null;
                this.firstValue = null;
            }
        }
        return this;
    }

    public MapFactory<K, V> add(K key, V value) {
        if (this.exported) {
            throw new IllegalStateException();
        }
        if (key != null && (this.filter == null || this.filter.allows(new Entry<K, V>(key, value)))) {
            if (this.map != null) {
                this.map.put(key, value);
            } else if (this.firstKey != null) {
                this.map = new HashMap();
                this.map.put(this.firstKey, this.firstValue);
                this.map.put(key, value);
                this.firstKey = null;
                this.firstValue = null;
            } else {
                this.firstKey = key;
                this.firstValue = value;
            }
        }
        return this;
    }

    public MapFactory<K, V> add(Map<K, V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public V remove(K key) {
        V removed = null;
        if (this.map != null) {
            removed = this.map.remove(key);
            if (this.map.size() == 1) {
                Map.Entry<K, V> entry = this.map.entrySet().iterator().next();
                this.firstKey = entry.getKey();
                this.firstValue = entry.getValue();
                this.map = null;
            }
        } else if (this.firstKey != null && this.firstKey.equals(key)) {
            removed = this.firstValue;
            this.firstKey = null;
            this.firstValue = null;
        }
        return removed;
    }

    public V get(K key) {
        V value = null;
        if (this.map != null) {
            value = this.map.get(key);
        } else if (this.firstKey != null && this.firstKey.equals(key)) {
            value = this.firstValue;
        }
        return value;
    }

    public boolean contains(K key) {
        return this.containsKey(key);
    }

    public boolean containsKey(K key) {
        boolean contains = false;
        if (this.map != null) {
            contains = this.map.containsKey(key);
        } else if (this.firstKey != null && this.firstKey.equals(key)) {
            contains = true;
        }
        return contains;
    }

    public boolean containsValue(V value) {
        boolean contains = false;
        if (this.map != null) {
            contains = this.map.containsValue(value);
        } else if (this.firstValue != null && this.firstValue.equals(value)) {
            contains = true;
        }
        return contains;
    }

    public int size() {
        int size = this.map != null ? this.map.size() : (this.firstKey != null ? 1 : 0);
        return size;
    }

    public Map<K, V> result() {
        if (this.exported) {
            throw new IllegalStateException();
        }
        this.exported = true;
        if (this.map != null) {
            return Collections.unmodifiableMap(this.map);
        }
        if (this.firstKey != null) {
            return Collections.singletonMap(this.firstKey, this.firstValue);
        }
        return Collections.emptyMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

