/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.parts;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.DecoratorImageFigure;
import org.eclipse.sapphire.ui.swt.gef.figures.NodeFigure;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

public final class NodeCellEditorLocator
implements CellEditorLocator {
    private Label label;
    private DiagramConfigurationManager manager;

    public NodeCellEditorLocator(DiagramConfigurationManager manager, Label label) {
        this.manager = manager;
        this.setLabel(label);
    }

    public void relocate(CellEditor celleditor) {
        double zoom = this.manager.getDiagramEditor().getZoomLevel();
        Rectangle labelRect = this.label.getClientArea();
        int margin = 2;
        if (this.label.getParent() instanceof NodeFigure && ((NodeFigure)this.label.getParent()).hasBorder()) {
            margin = 4;
        }
        labelRect.x += margin;
        labelRect.width -= margin + margin;
        labelRect.width = (int)((double)labelRect.width * zoom);
        Text text = (Text)celleditor.getControl();
        Point size = text.computeSize(-1, -1);
        size.x = Math.min(size.x, labelRect.width - 2);
        if (text.getText().length() == 0) {
            size.x = 10;
        }
        int rightOffset = 0;
        for (Object object : this.label.getParent().getChildren()) {
            if (!(object instanceof DecoratorImageFigure)) continue;
            Rectangle imageRect = ((DecoratorImageFigure)((Object)object)).getBounds();
            int imageWidth = ((DecoratorImageFigure)((Object)object)).getBounds().width;
            imageWidth = (int)((double)imageWidth * zoom);
            int newX = imageRect.x + imageWidth + margin;
            if (imageRect.x - 2 >= labelRect.x || newX >= labelRect.x + labelRect.width / 2 || imageRect.y - 2 > labelRect.y || labelRect.y > imageRect.y + 2) continue;
            rightOffset = newX - labelRect.x;
        }
        int offset = 0;
        if (size.x < labelRect.width) {
            offset = (labelRect.width - size.x + 1) / 2;
            if (rightOffset > 0 && offset < rightOffset) {
                offset = rightOffset;
            }
        }
        size.x = Math.min(size.x, rightOffset == 0 ? labelRect.width : labelRect.width - rightOffset - 1);
        this.label.translateToAbsolute((Translatable)labelRect);
        text.setBounds(labelRect.x + offset, labelRect.y + 1, size.x, size.y + 1);
    }

    protected Label getLabel() {
        return this.label;
    }

    protected void setLabel(Label label) {
        this.label = label;
    }
}

