/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.binding.t0012;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0012.TestElement;
import org.eclipse.sapphire.tests.modeling.xml.binding.t0012.TestListEntry;

public final class TestXmlBinding0012
extends SapphireTestCase {
    private TestXmlBinding0012(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestXmlBinding0012");
        suite.addTest((Test)new TestXmlBinding0012("testInsertOneAtEnd"));
        suite.addTest((Test)new TestXmlBinding0012("testInsertTwoAtEnd"));
        suite.addTest((Test)new TestXmlBinding0012("testMoveUp"));
        suite.addTest((Test)new TestXmlBinding0012("testMoveDown"));
        return suite;
    }

    public void testInsertOneAtEnd() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        TestElement element = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        try {
            TestListEntry x = (TestListEntry)element.getList().insert();
            x.setValue("x");
        }
        finally {
            element.dispose();
        }
    }

    public void testInsertTwoAtEnd() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        TestElement element = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        try {
            ModelElementList<TestListEntry> list = element.getList();
            TestListEntry x = (TestListEntry)list.insert();
            x.setValue("x");
            TestListEntry y = (TestListEntry)list.insert();
            y.setValue("y");
        }
        finally {
            element.dispose();
        }
    }

    public void testMoveUp() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        TestElement element = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        try {
            ModelElementList<TestListEntry> list = element.getList();
            TestListEntry x = (TestListEntry)list.insert();
            x.setValue("x");
            TestListEntry y = (TestListEntry)list.insert();
            y.setValue("y");
            TestListEntry z = (TestListEntry)list.insert();
            z.setValue("z");
            list.moveUp((IModelElement)z);
            TestXmlBinding0012.assertEquals((int)3, (int)list.size());
            TestXmlBinding0012.assertSame((Object)x, (Object)list.get(0));
            TestXmlBinding0012.assertEquals((String)x.getValue().getText(), (String)"x");
            TestXmlBinding0012.assertSame((Object)z, (Object)list.get(1));
            TestXmlBinding0012.assertEquals((String)z.getValue().getText(), (String)"z");
            TestXmlBinding0012.assertSame((Object)y, (Object)list.get(2));
            TestXmlBinding0012.assertEquals((String)y.getValue().getText(), (String)"y");
            list.moveUp((IModelElement)z);
            TestXmlBinding0012.assertEquals((int)3, (int)list.size());
            TestXmlBinding0012.assertSame((Object)z, (Object)list.get(0));
            TestXmlBinding0012.assertEquals((String)z.getValue().getText(), (String)"z");
            TestXmlBinding0012.assertSame((Object)x, (Object)list.get(1));
            TestXmlBinding0012.assertEquals((String)x.getValue().getText(), (String)"x");
            TestXmlBinding0012.assertSame((Object)y, (Object)list.get(2));
            TestXmlBinding0012.assertEquals((String)y.getValue().getText(), (String)"y");
        }
        finally {
            element.dispose();
        }
    }

    public void testMoveDown() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        TestElement element = (TestElement)TestElement.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        try {
            ModelElementList<TestListEntry> list = element.getList();
            TestListEntry x = (TestListEntry)list.insert();
            x.setValue("x");
            TestListEntry y = (TestListEntry)list.insert();
            y.setValue("y");
            TestListEntry z = (TestListEntry)list.insert();
            z.setValue("z");
            list.moveDown((IModelElement)x);
            TestXmlBinding0012.assertEquals((int)3, (int)list.size());
            TestXmlBinding0012.assertSame((Object)y, (Object)list.get(0));
            TestXmlBinding0012.assertEquals((String)y.getValue().getText(), (String)"y");
            TestXmlBinding0012.assertSame((Object)x, (Object)list.get(1));
            TestXmlBinding0012.assertEquals((String)x.getValue().getText(), (String)"x");
            TestXmlBinding0012.assertSame((Object)z, (Object)list.get(2));
            TestXmlBinding0012.assertEquals((String)z.getValue().getText(), (String)"z");
            list.moveDown((IModelElement)x);
            TestXmlBinding0012.assertEquals((int)3, (int)list.size());
            TestXmlBinding0012.assertSame((Object)y, (Object)list.get(0));
            TestXmlBinding0012.assertEquals((String)y.getValue().getText(), (String)"y");
            TestXmlBinding0012.assertSame((Object)z, (Object)list.get(1));
            TestXmlBinding0012.assertEquals((String)z.getValue().getText(), (String)"z");
            TestXmlBinding0012.assertSame((Object)x, (Object)list.get(2));
            TestXmlBinding0012.assertEquals((String)x.getValue().getText(), (String)"x");
        }
        finally {
            element.dispose();
        }
    }
}

