/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.internal;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FileName;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.InitialValueServiceData;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;

public final class CreateWorkspaceFileOpServices {

    public static final class FileNameValidationService
    extends ValidationService {
        private FileExtensionsService fileExtensionsService;

        protected void init() {
            super.init();
            final IModelElement element = (IModelElement)this.context(IModelElement.class);
            final ModelProperty property = (ModelProperty)this.context(ModelProperty.class);
            this.fileExtensionsService = (FileExtensionsService)element.service(property, FileExtensionsService.class);
            if (this.fileExtensionsService != null) {
                this.fileExtensionsService.attach(new Listener(){

                    public void handle(Event event) {
                        element.refresh(property);
                    }
                });
            }
        }

        public Status validate() {
            Value value = ((IModelElement)this.context(IModelElement.class)).read((ValueProperty)this.context(ValueProperty.class));
            FileName fileName = (FileName)value.getContent();
            if (fileName != null) {
                CreateWorkspaceFileOp operation;
                IFile fileHandle;
                List extensions;
                int count;
                String extension = fileName.extension();
                if (extension != null && this.fileExtensionsService != null && (count = (extensions = this.fileExtensionsService.extensions()).size()) > 0) {
                    boolean match = false;
                    for (String ext : extensions) {
                        if (!extension.equalsIgnoreCase(ext)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        String message;
                        if (count == 1) {
                            message = NLS.bind((String)Resources.invalidFileExtensionOne, (Object[])new Object[]{extensions.get(0)});
                        } else if (count == 2) {
                            message = NLS.bind((String)Resources.invalidFileExtensionTwo, (Object[])new Object[]{extensions.get(0), extensions.get(1)});
                        } else {
                            StringBuilder buf = new StringBuilder();
                            for (String ext : extensions) {
                                if (buf.length() != 0) {
                                    buf.append(", ");
                                }
                                buf.append(ext);
                            }
                            message = NLS.bind((String)Resources.invalidFileExtensionMultiple, (Object[])new Object[]{buf.toString()});
                        }
                        return Status.createWarningStatus((String)message);
                    }
                }
                if ((fileHandle = (operation = (CreateWorkspaceFileOp)value.nearest(CreateWorkspaceFileOp.class)).getFileHandle()) != null && fileHandle.exists() && !((Boolean)operation.getOverwriteExistingFile().getContent()).booleanValue()) {
                    String msg = NLS.bind((String)Resources.fileExists, (Object[])new Object[]{fileName});
                    return Status.factoryForLeaf().severity(Status.Severity.ERROR).type("Sapphire.Workspace.CreateFileOp.FileExists").message(msg).create();
                }
            }
            return Status.createOkStatus();
        }
    }

    public static final class FolderInitialValueService
    extends InitialValueService {
        private Listener listener;

        protected void initInitialValueService() {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    FolderInitialValueService.this.refresh();
                }
            };
            ((CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class)).attach(this.listener, (ModelProperty)CreateWorkspaceFileOp.PROP_CONTEXT);
        }

        protected InitialValueServiceData compute() {
            CreateWorkspaceFileOp op = (CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class);
            IResource resource = (IResource)op.getContext().content();
            if (resource instanceof IFile) {
                resource = resource.getParent();
            }
            return new InitialValueServiceData(resource == null ? null : resource.getFullPath().makeRelative().toPortableString());
        }

        public void dispose() {
            super.dispose();
            if (this.listener != null) {
                ((CreateWorkspaceFileOp)this.context(CreateWorkspaceFileOp.class)).detach(this.listener, (ModelProperty)CreateWorkspaceFileOp.PROP_CONTEXT);
            }
        }
    }

    public static final class FolderValidationService
    extends ValidationService {
        public Status validate() {
            Value target = ((IModelElement)this.context(IModelElement.class)).read((ValueProperty)this.context(ValueProperty.class));
            Path path = (Path)target.getContent();
            if (path != null && path.segmentCount() > 0) {
                String projectName = path.segment(0);
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(projectName);
                if (resource == null || !(resource instanceof IProject) || !resource.isAccessible()) {
                    String msg = NLS.bind((String)Resources.projectDoesNotExist, (Object[])new Object[]{projectName});
                    return Status.createErrorStatus((String)msg);
                }
            }
            return Status.createOkStatus();
        }
    }

    private static final class Resources
    extends NLS {
        public static String projectDoesNotExist;
        public static String fileExists;
        public static String invalidFileExtensionOne;
        public static String invalidFileExtensionTwo;
        public static String invalidFileExtensionMultiple;

        static {
            Resources.initializeMessages((String)CreateWorkspaceFileOpServices.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

