/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

public abstract class RequiredPropertyValidationService
extends ValidationService {
    public final Status validate() {
        if (this.check()) {
            return Status.createOkStatus();
        }
        String label = this.context(ModelProperty.class).getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false);
        String message = NLS.bind(Resources.message, label);
        return Status.createErrorStatus(message);
    }

    protected abstract boolean check();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ModelProperty property = context.find(ModelProperty.class);
            return property.hasAnnotation(Required.class) && (property instanceof ValueProperty || property instanceof ElementProperty && !(property instanceof ImpliedElementProperty));
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            ModelProperty property = context.find(ModelProperty.class);
            if (property instanceof ValueProperty) {
                return new RequiredPropertyValidationService(){

                    protected boolean check() {
                        return this.context(IModelElement.class).read(this.context(ValueProperty.class)).getText() != null;
                    }
                };
            }
            return new RequiredPropertyValidationService(){

                protected boolean check() {
                    return this.context(IModelElement.class).read(this.context(ElementProperty.class)).element() != null;
                }
            };
        }
    }

    private static final class Resources
    extends NLS {
        public static String message;

        static {
            Resources.initializeMessages(RequiredPropertyValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

