/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.processor.internal;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.SourcePosition;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.sdk.build.processor.internal.SapphireAnnotationsProcessor;
import org.eclipse.sapphire.sdk.build.processor.internal.util.Body;
import org.eclipse.sapphire.sdk.build.processor.internal.util.ClassModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.IndentingPrintWriter;
import org.eclipse.sapphire.sdk.build.processor.internal.util.MethodModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.MethodParameterModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.ParameterizedTypeReference;
import org.eclipse.sapphire.sdk.build.processor.internal.util.TypeReference;
import org.eclipse.sapphire.sdk.build.processor.internal.util.WildcardTypeReference;
import org.eclipse.sapphire.services.ValueSerializationMasterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenerateImplProcessor
extends SapphireAnnotationsProcessor {
    @Override
    public void process(AnnotationProcessorEnvironment env, Declaration annotatedEntity, AnnotationMirror annotation) {
        block7: {
            try {
                if (annotation == null || annotatedEntity == null) {
                    return;
                }
                if (!(annotatedEntity instanceof InterfaceDeclaration)) {
                    return;
                }
                InterfaceDeclaration interfaceDeclaration = (InterfaceDeclaration)annotatedEntity;
                ClassModel implClassModel = new ClassModel();
                this.process(env.getMessager(), implClassModel, interfaceDeclaration);
                if (implClassModel.isInvalid()) break block7;
                PrintWriter pw = env.getFiler().createSourceFile(implClassModel.getName().getQualifiedName());
                try {
                    implClassModel.write(new IndentingPrintWriter(pw));
                }
                finally {
                    pw.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static boolean isInstanceOf(TypeMirror type, String interfaceOrClass) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            return GenerateImplProcessor.isInstanceOf(declaredType.getDeclaration(), interfaceOrClass);
        }
        return false;
    }

    protected static boolean isInstanceOf(TypeDeclaration type, String interfaceOrClass) {
        if (type != null) {
            ClassType superClassType;
            if (type.getQualifiedName().equals(interfaceOrClass)) {
                return true;
            }
            if (type instanceof ClassDeclaration && (superClassType = ((ClassDeclaration)type).getSuperclass()) != null && GenerateImplProcessor.isInstanceOf((TypeDeclaration)superClassType.getDeclaration(), interfaceOrClass)) {
                return true;
            }
            for (InterfaceType superInterface : type.getSuperinterfaces()) {
                if (!GenerateImplProcessor.isInstanceOf((TypeMirror)superInterface, interfaceOrClass)) continue;
                return true;
            }
        }
        return false;
    }

    private void process(Messager messager, final ClassModel elImplClass, InterfaceDeclaration elInterface) {
        GenerateImpl generateImplAnnotation = (GenerateImpl)elInterface.getAnnotation(GenerateImpl.class);
        String implClassQualifiedName = ModelElementType.getImplClassName((String)GenerateImplProcessor.getQualifiedName((TypeDeclaration)elInterface), (GenerateImpl)generateImplAnnotation);
        elImplClass.setName(new TypeReference(implClassQualifiedName));
        elImplClass.addInterface(new TypeReference(elInterface.getQualifiedName()));
        elImplClass.setBaseClass(new TypeReference(ModelElement.class.getName()));
        MethodModel c = elImplClass.addConstructor();
        c.addParameter(new MethodParameterModel("parent", IModelParticle.class));
        c.addParameter(new MethodParameterModel("parentProperty", ModelProperty.class));
        c.addParameter(new MethodParameterModel("resource", Resource.class));
        c.getBody().append("super( TYPE, parent, parentProperty, resource );");
        elImplClass.addImport(PropertyInitializationEvent.class);
        elImplClass.addImport(PropertyContentEvent.class);
        elImplClass.addImport(PropertyValidationEvent.class);
        elImplClass.addImport(PropertyEnablementEvent.class);
        final TreeMap propFields = new TreeMap();
        Visitor<FieldDeclaration> fieldsVisitor = new Visitor<FieldDeclaration>(){

            @Override
            public void visit(FieldDeclaration field) {
                String fieldName = field.getSimpleName();
                if (fieldName != null && fieldName.startsWith("PROP_")) {
                    PropertyFieldDeclaration propFieldDeclaration = (PropertyFieldDeclaration)propFields.get(fieldName);
                    if (propFieldDeclaration == null) {
                        propFieldDeclaration = new PropertyFieldDeclaration();
                        propFieldDeclaration.name = fieldName;
                        propFieldDeclaration.propertyName = GenerateImplProcessor.preparePropName(fieldName);
                        propFields.put(fieldName, propFieldDeclaration);
                    }
                    propFieldDeclaration.declarations.addFirst(field);
                }
            }
        };
        GenerateImplProcessor.visitAllFields(elInterface, fieldsVisitor);
        for (PropertyFieldDeclaration field : propFields.values()) {
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ValueProperty.class.getName())) {
                this.processValueProperty(messager, elImplClass, elInterface, field);
                continue;
            }
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ElementProperty.class.getName())) {
                this.processElementProperty(messager, elImplClass, elInterface, field);
                continue;
            }
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ListProperty.class.getName())) {
                this.processListProperty(messager, elImplClass, elInterface, field);
                continue;
            }
            if (!GenerateImplProcessor.isInstanceOf(field.getType(), TransientProperty.class.getName())) continue;
            this.processTransientProperty(messager, elImplClass, elInterface, field);
        }
        Visitor<MethodDeclaration> methodsVisitor = new Visitor<MethodDeclaration>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void visit(MethodDeclaration method) {
                DelegateImplementation delegateImplementationAnnotation = (DelegateImplementation)method.getAnnotation(DelegateImplementation.class);
                if (delegateImplementationAnnotation != null) {
                    String methodName = method.getSimpleName();
                    TypeReference methodReturnType = GenerateImplProcessor.toTypeReference(method.getReturnType());
                    ArrayList<TypeReference> methodParametersList = new ArrayList<TypeReference>();
                    LinkedHashMap<String, TypeReference> methodParametersMap = new LinkedHashMap<String, TypeReference>();
                    for (ParameterDeclaration param : method.getParameters()) {
                        TypeReference type = GenerateImplProcessor.toTypeReference(param.getType());
                        methodParametersList.add(type);
                        methodParametersMap.put(param.getSimpleName(), type);
                    }
                    if (!elImplClass.hasMethod(methodName, methodParametersList)) {
                        void var8_12;
                        MethodModel m = elImplClass.addMethod(methodName);
                        m.setReturnType(methodReturnType);
                        for (Map.Entry entry : methodParametersMap.entrySet()) {
                            MethodParameterModel p = new MethodParameterModel();
                            p.setName((String)entry.getKey());
                            p.setType((TypeReference)entry.getValue());
                            m.addParameter(p);
                        }
                        Object var8_10 = null;
                        try {
                            delegateImplementationAnnotation.value();
                        }
                        catch (MirroredTypeException e) {
                            ClassDeclaration typeMirror = ((ClassType)e.getTypeMirror()).getDeclaration();
                            TypeReference typeReference = new TypeReference(typeMirror.getQualifiedName());
                        }
                        Body mb = m.getBody();
                        mb.append("synchronized( root() )");
                        mb.openBlock();
                        StringBuilder buf = new StringBuilder();
                        buf.append("assertNotDisposed();\n\n");
                        if (m.getReturnType() != TypeReference.VOID_TYPE) {
                            buf.append("return ");
                        }
                        buf.append(var8_12.getSimpleName()).append('.').append(m.getName()).append("( this");
                        for (MethodParameterModel param : m.getParameters()) {
                            buf.append(", ");
                            buf.append(param.getName());
                        }
                        buf.append(" );");
                        mb.append(buf.toString());
                        mb.closeBlock();
                        elImplClass.addImport((TypeReference)var8_12);
                    }
                }
            }
        };
        GenerateImplProcessor.visitAllMethods(elInterface, methodsVisitor);
    }

    private void processValueProperty(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processValuePropertyInternal(messager, implClassModel, interfaceDeclaration, propField);
        }
        catch (AbortException abortException) {
            implClassModel.markInvalid();
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processValueProperty() method call.");
            pw.println();
            pw.println("interfaceDeclaration : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processValuePropertyInternal(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        TypeReference baseType = null;
        ParameterizedTypeReference wrapperType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        if (typeAnnotation == null) {
            baseType = new TypeReference(String.class);
        } else {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                baseType = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        Reference referenceAnnotation = propField.getAnnotation(Reference.class);
        if (referenceAnnotation != null) {
            try {
                referenceAnnotation.target();
            }
            catch (MirroredTypeException e) {
                TypeMirror mirror = e.getTypeMirror();
                TypeReference targetType = GenerateImplProcessor.toTypeReference(mirror);
                Collection typeParams = mirror instanceof TypeDeclaration ? ((TypeDeclaration)mirror).getFormalTypeParameters() : ((DeclaredType)mirror).getDeclaration().getFormalTypeParameters();
                if (!typeParams.isEmpty()) {
                    Object[] params = new TypeReference[typeParams.size()];
                    Arrays.fill(params, WildcardTypeReference.INSTANCE);
                    targetType = targetType.parameterize((TypeReference[])params);
                }
                wrapperType = new TypeReference(ReferenceValue.class).parameterize(baseType, targetType);
            }
        } else {
            wrapperType = new TypeReference(Value.class).parameterize(baseType);
        }
        boolean hasDerivedValueProviderAnnotation = propField.getAnnotation(Derived.class) != null;
        String getterMethodName = null;
        InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
        String getterAlt1 = "get" + propField.propertyName;
        String getterAlt2 = "is" + propField.propertyName;
        MethodDeclaration getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, getterAlt1, new String[0]);
        if (getterMethodInInterface == null) {
            getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, getterAlt2, new String[0]);
        }
        if (getterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindGetter, (Object[])new Object[]{modelElementInterface.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        getterMethodName = getterMethodInInterface.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        MethodModel getter = implClassModel.addMethod();
        getter.setName(getterMethodName);
        getter.setReturnType(wrapperType);
        Body gb = getter.getBody();
        gb.append("return (#1) read( #2 );", ((TypeReference)wrapperType).getBase().getSimpleName(), propField.name);
        if (!hasDerivedValueProviderAnnotation && propField.getAnnotation(ReadOnly.class) == null) {
            MethodDeclaration setterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, "set" + propField.propertyName, "java.lang.String");
            if (setterMethodInInterface == null) {
                String msg = NLS.bind((String)Resources.unableToFindStringSetter, (Object[])new Object[]{modelElementInterface.getSimpleName(), propField.name});
                messager.printError(propField.getSourcePosition(), msg);
                throw new AbortException();
            }
            String setterMethodName = setterMethodInInterface.getSimpleName();
            propField.setSetterMethodName(setterMethodName);
            MethodModel setter = null;
            setter = implClassModel.addMethod();
            setter.setName(setterMethodName);
            MethodParameterModel setterParam = new MethodParameterModel("value", String.class);
            setterParam.setFinal(false);
            setter.addParameter(setterParam);
            Body sb = setter.getBody();
            sb.append("write( #1, value );", propField.name);
            implClassModel.addImport(MiscUtil.class);
            if (!baseType.getQualifiedName().equals(String.class.getName())) {
                MethodDeclaration typedSetterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, "set" + propField.propertyName, baseType.getQualifiedName());
                if (typedSetterMethodInInterface == null) {
                    String msg = NLS.bind((String)Resources.unableToFindTypedSetter, (Object[])new Object[]{modelElementInterface.getSimpleName(), propField.name});
                    messager.printError(propField.getSourcePosition(), msg);
                    throw new AbortException();
                }
                String typeSetterMethodName = typedSetterMethodInInterface.getSimpleName();
                propField.setTypedSetterMethodName(typeSetterMethodName);
                MethodModel setterForTyped = implClassModel.addMethod();
                setterForTyped.setName(typeSetterMethodName);
                setterForTyped.addParameter(new MethodParameterModel("value", baseType));
                Body stb = setterForTyped.getBody();
                stb.append("write( #1, value );", propField.name);
                implClassModel.addImport(ValueSerializationMasterService.class);
            }
        } else {
            MethodDeclaration typedSetterMethodInInterface;
            MethodDeclaration setterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, "set" + propField.propertyName, "java.lang.String");
            if (setterMethodInInterface != null) {
                String setterMethodName = setterMethodInInterface.getSimpleName();
                propField.setSetterMethodName(setterMethodName);
                MethodModel setter = null;
                setter = implClassModel.addMethod();
                setter.setName(setterMethodName);
                MethodParameterModel setterParam = new MethodParameterModel("value", String.class);
                setterParam.setFinal(false);
                setter.addParameter(setterParam);
                Body sb = setter.getBody();
                sb.append("throw new UnsupportedOperationException();");
            }
            if (!baseType.getQualifiedName().equals(String.class.getName()) && (typedSetterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, "set" + propField.propertyName, baseType.getQualifiedName())) != null) {
                String typeSetterMethodName = typedSetterMethodInInterface.getSimpleName();
                propField.setTypedSetterMethodName(typeSetterMethodName);
                MethodModel setterForTyped = implClassModel.addMethod();
                setterForTyped.setName(typeSetterMethodName);
                setterForTyped.addParameter(new MethodParameterModel("value", baseType));
                Body stb = setterForTyped.getBody();
                stb.append("throw new UnsupportedOperationException();");
            }
        }
    }

    private void processElementProperty(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processElementPropertyInternal(messager, implClassModel, interfaceDeclaration, propField);
        }
        catch (AbortException abortException) {
            implClassModel.markInvalid();
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processElementProperty() method call.");
            pw.println();
            pw.println("modelElementInterface : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processElementPropertyInternal(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        boolean isImplied = GenerateImplProcessor.isInstanceOf(propField.getType(), ImpliedElementProperty.class.getName());
        MethodDeclaration getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(interfaceDeclaration, "get" + propField.propertyName, new String[0]);
        if (getterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindGetter, (Object[])new Object[]{interfaceDeclaration.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        String getterMethodName = getterMethodInInterface.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        TypeReference memberType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        try {
            typeAnnotation.base();
        }
        catch (MirroredTypeException e) {
            InterfaceDeclaration typeMirror = ((InterfaceType)e.getTypeMirror()).getDeclaration();
            memberType = new TypeReference(typeMirror.getQualifiedName());
        }
        ParameterizedTypeReference handleType = new TypeReference(ModelElementHandle.class).parameterize(memberType);
        MethodModel g = implClassModel.addMethod();
        g.setName(getterMethodName);
        g.setReturnType(isImplied ? memberType : handleType);
        Body gb = g.getBody();
        if (isImplied) {
            gb.append("return (#2) ( (ModelElementHandle) read( #1 ) ).element();", propField.name, memberType.getSimpleName());
        } else {
            gb.append("return (ModelElementHandle) read( #1 );", propField.name);
        }
        implClassModel.addImport(ModelElementHandle.class);
        implClassModel.addImport(IModelElement.class);
    }

    private void processListProperty(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processListPropertyInternal(messager, implClassModel, interfaceDeclaration, propField);
        }
        catch (AbortException abortException) {
            implClassModel.markInvalid();
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processListProperty() method call.");
            pw.println();
            pw.println("modelElementInterface : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processListPropertyInternal(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        MethodDeclaration getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(interfaceDeclaration, "get" + propField.propertyName, new String[0]);
        if (getterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindGetter, (Object[])new Object[]{interfaceDeclaration.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        String getterMethodName = getterMethodInInterface.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        TypeReference memberType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        try {
            typeAnnotation.base();
        }
        catch (MirroredTypeException e) {
            InterfaceDeclaration typeMirror = ((InterfaceType)e.getTypeMirror()).getDeclaration();
            memberType = new TypeReference(typeMirror.getQualifiedName());
        }
        ParameterizedTypeReference listType = new TypeReference(ModelElementList.class).parameterize(memberType);
        MethodModel g = implClassModel.addMethod();
        g.setName(getterMethodName);
        g.setReturnType(listType);
        Body gb = g.getBody();
        gb.append("return (ModelElementList) read( #1 );", propField.name);
        implClassModel.addImport(IModelElement.class);
    }

    private void processTransientProperty(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processTransientPropertyInternal(messager, implClassModel, interfaceDeclaration, propField);
        }
        catch (AbortException abortException) {
            implClassModel.markInvalid();
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processTransientProperty() method call.");
            pw.println();
            pw.println("interfaceDeclaration : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processTransientPropertyInternal(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        TypeReference baseType = null;
        ParameterizedTypeReference wrapperType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        if (typeAnnotation == null) {
            baseType = new TypeReference(Object.class);
        } else {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                baseType = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        wrapperType = new TypeReference(Transient.class).parameterize(baseType);
        MethodDeclaration getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(interfaceDeclaration, "get" + propField.propertyName, new String[0]);
        if (getterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindGetter, (Object[])new Object[]{interfaceDeclaration.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        String getterMethodName = getterMethodInInterface.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        MethodDeclaration setterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(interfaceDeclaration, "set" + propField.propertyName, baseType.getQualifiedName());
        if (setterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindSetter, (Object[])new Object[]{interfaceDeclaration.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        String setterMethodName = setterMethodInInterface.getSimpleName();
        propField.setSetterMethodName(setterMethodName);
        MethodModel getter = implClassModel.addMethod();
        getter.setName(getterMethodName);
        getter.setReturnType(wrapperType);
        Body gb = getter.getBody();
        gb.append("return (Transient) read( #1 );", propField.name);
        MethodModel setter = implClassModel.addMethod();
        setter.setName(setterMethodName);
        MethodParameterModel param = new MethodParameterModel("object", baseType);
        setter.addParameter(param);
        Body sb = setter.getBody();
        sb.append("write( #1, object );", propField.name);
        implClassModel.addImport(MiscUtil.class);
    }

    private static MethodDeclaration findMethodDeclaration(InterfaceDeclaration interfaceDeclaration, String methodName, String ... paramTypes) {
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            Collection params;
            if (!method.getSimpleName().equalsIgnoreCase(methodName) || (params = method.getParameters()).size() != paramTypes.length) continue;
            Iterator itr = params.iterator();
            boolean paramsMatch = true;
            String[] stringArray = paramTypes;
            int n = paramTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration actualParamTypeDeclaration;
                String expectedParamTypeName = stringArray[n2];
                TypeMirror actualParamType = ((ParameterDeclaration)itr.next()).getType();
                if (actualParamType instanceof DeclaredType && ((actualParamTypeDeclaration = ((DeclaredType)actualParamType).getDeclaration()) == null || !actualParamTypeDeclaration.getQualifiedName().equals(expectedParamTypeName))) {
                    paramsMatch = false;
                    break;
                }
                ++n2;
            }
            if (!paramsMatch) continue;
            return method;
        }
        for (InterfaceType superInterfaceType : interfaceDeclaration.getSuperinterfaces()) {
            MethodDeclaration method = GenerateImplProcessor.findMethodDeclaration(superInterfaceType.getDeclaration(), methodName, paramTypes);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static String preparePropName(String propFieldName) {
        StringBuilder buf = new StringBuilder();
        boolean seenFirstSegment = false;
        String[] stringArray = propFieldName.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (seenFirstSegment) {
                buf.append(segment.charAt(0));
                buf.append(segment.substring(1).toLowerCase());
            } else {
                seenFirstSegment = true;
            }
            ++n2;
        }
        return buf.toString();
    }

    private static void visitAllMethods(InterfaceDeclaration interfaceDeclaration, Visitor<MethodDeclaration> visitor) {
        GenerateImplProcessor.visitAllMethods(interfaceDeclaration, visitor, new HashSet<InterfaceDeclaration>());
    }

    private static void visitAllMethods(InterfaceDeclaration interfaceDeclaration, Visitor<MethodDeclaration> visitor, Set<InterfaceDeclaration> visited) {
        visited.add(interfaceDeclaration);
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            visitor.visit(method);
        }
        for (InterfaceType superInterface : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superInterface.getDeclaration();
            if (visited.contains(superInterfaceDeclaration)) continue;
            GenerateImplProcessor.visitAllMethods(superInterfaceDeclaration, visitor, visited);
        }
    }

    private static void visitAllFields(InterfaceDeclaration interfaceDeclaration, Visitor<FieldDeclaration> visitor) {
        GenerateImplProcessor.visitAllFields(interfaceDeclaration, visitor, new HashSet<InterfaceDeclaration>());
    }

    private static void visitAllFields(InterfaceDeclaration interfaceDeclaration, Visitor<FieldDeclaration> visitor, Set<InterfaceDeclaration> visited) {
        visited.add(interfaceDeclaration);
        for (InterfaceType superInterface : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superInterface.getDeclaration();
            if (visited.contains(superInterfaceDeclaration)) continue;
            GenerateImplProcessor.visitAllFields(superInterfaceDeclaration, visitor, visited);
        }
        for (FieldDeclaration field : interfaceDeclaration.getFields()) {
            visitor.visit(field);
        }
    }

    private static TypeReference toTypeReference(TypeMirror typeMirror) {
        if (typeMirror instanceof VoidType) {
            return TypeReference.VOID_TYPE;
        }
        if (typeMirror instanceof PrimitiveType) {
            return TypeReference.PRIMITIVE_TYPES.get(((PrimitiveType)typeMirror).getKind());
        }
        if (typeMirror instanceof DeclaredType) {
            return new TypeReference(((DeclaredType)typeMirror).getDeclaration().getQualifiedName());
        }
        if (typeMirror instanceof ArrayType) {
            return GenerateImplProcessor.toTypeReference(((ArrayType)typeMirror).getComponentType()).array(1);
        }
        return new TypeReference(((TypeDeclaration)typeMirror).getQualifiedName());
    }

    private static String getQualifiedName(TypeDeclaration type) {
        StringBuilder qname = new StringBuilder();
        String pkg = type.getPackage().getQualifiedName();
        if (pkg.length() > 0) {
            qname.append(pkg);
            qname.append('.');
            qname.append(type.getQualifiedName().substring(pkg.length() + 1).replace('.', '$'));
        } else {
            qname.append(type.getQualifiedName().replace('.', '$'));
        }
        return qname.toString();
    }

    private static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private AbortException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyFieldDeclaration {
        public String name;
        public String propertyName;
        public LinkedList<FieldDeclaration> declarations = new LinkedList();
        private String getterMethodName;
        private String setterMethodName;
        private String typedSetterMethodName;

        public boolean isElementProperty() {
            return GenerateImplProcessor.isInstanceOf(this.getType(), ElementProperty.class.getName());
        }

        public TypeMirror getType() {
            if (this.declarations.isEmpty()) {
                return null;
            }
            return this.declarations.getFirst().getType();
        }

        public InterfaceDeclaration getDeclaringType() {
            if (!this.declarations.isEmpty()) {
                TypeDeclaration declaringType = this.declarations.getFirst().getDeclaringType();
                if (declaringType instanceof InterfaceDeclaration) {
                    return (InterfaceDeclaration)declaringType;
                }
                if (declaringType instanceof InterfaceType) {
                    return ((InterfaceType)declaringType).getDeclaration();
                }
                throw new IllegalStateException();
            }
            return null;
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            Annotation annotation = null;
            for (FieldDeclaration fd : this.declarations) {
                annotation = fd.getAnnotation(annotationType);
                if (annotation != null) break;
            }
            return (A)annotation;
        }

        public String getGetterMethodName() {
            return this.getterMethodName;
        }

        public void setGetterMethodName(String getterMethodName) {
            this.getterMethodName = getterMethodName;
        }

        public String getSetterMethodName() {
            return this.setterMethodName;
        }

        public void setSetterMethodName(String setterMethodName) {
            this.setterMethodName = setterMethodName;
        }

        public String getTypedSetterMethodName() {
            return this.typedSetterMethodName;
        }

        public void setTypedSetterMethodName(String typedSetterMethodName) {
            this.typedSetterMethodName = typedSetterMethodName;
        }

        public SourcePosition getSourcePosition() {
            return this.declarations.get(0).getPosition();
        }
    }

    private static final class Resources
    extends NLS {
        public static String unableToFindGetter;
        public static String unableToFindSetter;
        public static String unableToFindStringSetter;
        public static String unableToFindTypedSetter;

        static {
            Resources.initializeMessages((String)GenerateImplProcessor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Visitor<T> {
        public void visit(T var1);
    }
}

