/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.ui.FormEditorPagePart;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorFormPage;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.def.FormEditorPageDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentation;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationRef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireToolBarManagerActionPresentation;
import org.eclipse.sapphire.ui.util.SapphireHelpSystem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormEditorPage
extends SapphireEditorFormPage {
    public FormEditorPage(SapphireEditor editor, IModelElement element, DefinitionLoader.Reference<EditorPageDef> definition) {
        this(editor, element, definition, null);
    }

    public FormEditorPage(SapphireEditor editor, IModelElement element, DefinitionLoader.Reference<EditorPageDef> definition, String pageName) {
        super(editor, element, definition);
        String partName = pageName;
        if (partName == null) {
            partName = this.getDefinition().getPageName().getLocalizedText(CapitalizationType.TITLE_STYLE, false);
        }
        this.setPartName(partName);
    }

    @Override
    public FormEditorPagePart getPart() {
        return (FormEditorPagePart)super.getPart();
    }

    public FormEditorPageDef getDefinition() {
        return this.getPart().definition();
    }

    @Override
    public String getId() {
        return this.getPartName();
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormEditorPagePart part = this.getPart();
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(managedForm.getForm().getForm());
        managedForm.getForm().getBody().setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        SapphireEditorFormPage.FormEditorRenderingContext context = new SapphireEditorFormPage.FormEditorRenderingContext((ISapphirePart)this.getPart(), managedForm);
        for (SapphirePart sapphirePart : part.getChildParts()) {
            sapphirePart.render(context);
        }
        ISapphireDocumentation iSapphireDocumentation = (ISapphireDocumentation)part.definition().getDocumentation().element();
        if (iSapphireDocumentation != null) {
            ISapphireDocumentationDef docdef = null;
            docdef = iSapphireDocumentation instanceof ISapphireDocumentationDef ? (ISapphireDocumentationDef)iSapphireDocumentation : ((ISapphireDocumentationRef)iSapphireDocumentation).resolve();
            if (docdef != null) {
                SapphireHelpSystem.setHelp((Control)managedForm.getForm().getBody(), docdef);
            }
        }
        SapphireActionGroup actions = part.getActions("Sapphire.EditorPage");
        SapphireToolBarManagerActionPresentation actionPresentation = new SapphireToolBarManagerActionPresentation(part, this.getSite().getShell(), actions);
        actionPresentation.setToolBarManager(form.getToolBarManager());
        actionPresentation.render();
    }
}

