/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.Set;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ISapphireLabelDef;
import org.eclipse.sapphire.ui.swt.SapphireTextPopup;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.sapphire.ui.swt.renderer.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.swt.renderer.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.swt.renderer.SwtUtil;
import org.eclipse.sapphire.ui.swt.renderer.internal.formtext.SapphireFormText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LabelPart
extends SapphirePart {
    private static final String BREAK_TOKEN = "###brk###";
    private SapphireFormText text;
    private String labelExtendedContent;
    private FunctionResult labelFunctionResult;

    @Override
    public Set<String> getActionContexts() {
        return Collections.singleton("Sapphire.Label");
    }

    @Override
    public void render(SapphireRenderingContext context) {
        ISapphireLabelDef def = (ISapphireLabelDef)this.definition;
        this.text = new SapphireFormText(context.getComposite(), 0);
        this.text.setLayoutData(GridLayoutUtil.gdhindent(GridLayoutUtil.gdwhint(GridLayoutUtil.gdhspan(GridLayoutUtil.gdhfill(), 2), 100), 9));
        context.adapt((Control)this.text);
        SapphireActionGroup actions = this.getActions(this.getMainActionContext());
        final SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(context, actions);
        SapphireKeyboardActionPresentation keyboardActionPresentation = new SapphireKeyboardActionPresentation(actionPresentationManager);
        keyboardActionPresentation.attach((Control)this.text);
        keyboardActionPresentation.render();
        this.labelFunctionResult = this.initExpression(this.getModelElement(), (Function)def.getText().getContent(), String.class, null, new Runnable(){

            public void run() {
                LabelPart.this.refreshLabel();
            }
        });
        this.text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                LabelPart.this.activateExtendedDescriptionContentPopup();
            }
        });
        this.refreshLabel();
        SwtUtil.reflowOnResize((Control)this.text);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                actionPresentationManager.dispose();
            }
        });
    }

    private void refreshLabel() {
        String description = null;
        if (this.labelFunctionResult != null) {
            description = (String)this.labelFunctionResult.value();
        }
        description = description == null ? "#null#" : description.trim();
        description = description.replace("<", "&lt;");
        int index = description.indexOf(BREAK_TOKEN);
        StringBuilder buf = new StringBuilder();
        buf.append("<form><p vspace=\"false\">");
        if (index > 0) {
            String displayDescription = description.substring(0, index);
            buf.append(displayDescription);
            if (!displayDescription.endsWith(" ")) {
                buf.append(" ");
            }
            buf.append("<a href=\"action\" nowrap=\"true\">");
            buf.append(Resources.moreDetails);
            buf.append("</a>");
            this.labelExtendedContent = String.valueOf(displayDescription) + description.substring(index + BREAK_TOKEN.length(), description.length());
        } else {
            buf.append(description);
            this.labelExtendedContent = null;
        }
        buf.append("</p></form>");
        this.text.setText(buf.toString(), true, false);
    }

    private void activateExtendedDescriptionContentPopup() {
        if (this.labelExtendedContent != null) {
            Point position;
            Point cursor = this.text.getDisplay().getCursorLocation();
            Rectangle bounds = this.text.getBounds();
            Point location = this.text.toDisplay(new Point(bounds.x, bounds.y));
            Rectangle displayBounds = new Rectangle(location.x, location.y, bounds.width, bounds.height);
            if (displayBounds.contains(cursor)) {
                position = cursor;
            } else {
                System.out.println("not in displayBounds: ");
                position = cursor;
            }
            SapphireTextPopup popup = new SapphireTextPopup(this.text.getShell(), position);
            popup.setText(this.labelExtendedContent);
            popup.open();
        }
    }

    private static final class Resources
    extends NLS {
        public static String moreDetails;

        static {
            Resources.initializeMessages((String)LabelPart.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

