/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.DisposeEvent;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.ui.SapphireActionLocationHint;
import org.eclipse.sapphire.ui.SapphireActionLocationHintAfter;
import org.eclipse.sapphire.ui.SapphireActionLocationHintBefore;
import org.eclipse.sapphire.ui.def.ActionLocationHint;
import org.eclipse.sapphire.ui.def.ActionLocationHintAfter;
import org.eclipse.sapphire.ui.def.ActionLocationHintBefore;
import org.eclipse.sapphire.ui.def.ActionSystemPartDef;
import org.eclipse.sapphire.ui.def.ImageReference;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireActionSystemPart {
    private FunctionContext functionContext;
    private String id;
    private FunctionResult labelFunctionResult;
    private FunctionResult toolTipFunctionResult;
    private String description;
    private final List<ImageData> images = new CopyOnWriteArrayList<ImageData>();
    private final List<SapphireActionLocationHint> locationHints = new CopyOnWriteArrayList<SapphireActionLocationHint>();
    private final List<SapphireActionLocationHint> locationHintsReadOnly = Collections.unmodifiableList(this.locationHints);
    private boolean visible;
    private boolean enabled;
    private boolean checked;
    private final ListenerContext listeners = new ListenerContext();

    protected final void init(ActionSystemPartDef def) {
        this.functionContext = this.initFunctionContext();
        if (def != null) {
            this.id = (String)def.getId().getContent();
            Function labelFunction = FailSafeFunction.create((Function)((Function)def.getLabel().getContent()), (Function)Literal.create(String.class));
            this.labelFunctionResult = labelFunction.evaluate(this.functionContext);
            this.labelFunctionResult.attach(new Listener(){

                public void handle(Event event) {
                    SapphireActionSystemPart.this.broadcast(new LabelChangedEvent());
                }
            });
            Function toolTipFunction = FailSafeFunction.create((Function)((Function)def.getToolTip().getContent()), (Function)Literal.create(String.class));
            this.toolTipFunctionResult = toolTipFunction.evaluate(this.functionContext);
            this.toolTipFunctionResult.attach(new Listener(){

                public void handle(Event event) {
                    SapphireActionSystemPart.this.broadcast(new ToolTipChangedEvent());
                }
            });
            this.description = (String)def.getDescription().getContent();
            for (ImageReference image : def.getImages()) {
                Function imageFunction = FailSafeFunction.create((Function)((Function)image.getImage().getContent()), (Function)Literal.create(ImageData.class));
                FunctionResult imageFunctionResult = imageFunction.evaluate(this.functionContext);
                ImageData data = (ImageData)imageFunctionResult.value();
                if (data != null) {
                    this.images.add(data);
                }
                imageFunctionResult.dispose();
            }
            for (ActionLocationHint locationHintDef : def.getLocationHints()) {
                SapphireActionLocationHint locationHint;
                String locationHintText = (String)locationHintDef.getReferenceEntityId().getContent();
                if (locationHintText == null) continue;
                if (locationHintDef instanceof ActionLocationHintBefore) {
                    locationHint = new SapphireActionLocationHintBefore(locationHintText);
                } else if (locationHintDef instanceof ActionLocationHintAfter) {
                    locationHint = new SapphireActionLocationHintAfter(locationHintText);
                } else {
                    throw new IllegalStateException();
                }
                this.locationHints.add(locationHint);
            }
        }
        this.enabled = true;
        this.visible = true;
    }

    protected abstract FunctionContext initFunctionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getId() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setId(String id) {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            this.id = id;
        }
        this.broadcast(new IdChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getLabel() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.labelFunctionResult == null ? null : (String)this.labelFunctionResult.value();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLabel(String label) {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            this.labelFunctionResult = Literal.create((Object)label).evaluate(this.functionContext);
        }
        this.broadcast(new LabelChangedEvent());
    }

    public final String getDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getToolTip() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.toolTipFunctionResult == null ? null : (String)this.toolTipFunctionResult.value();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setToolTip(String tooltip) {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            this.toolTipFunctionResult = Literal.create((Object)tooltip).evaluate(this.functionContext);
        }
        this.broadcast(new ToolTipChangedEvent());
    }

    public final ImageData getImage(int size) {
        for (ImageData image : this.images) {
            if (SwtRendererUtil.sizeOfImage(image) != size) continue;
            return image;
        }
        return null;
    }

    public final void addImage(ImageData image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.images.add(image);
        this.broadcast(new ImagesChangedEvent());
    }

    public final void removeImage(ImageData image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.images.remove(image);
        this.broadcast(new ImagesChangedEvent());
    }

    public final List<SapphireActionLocationHint> getLocationHints() {
        return this.locationHintsReadOnly;
    }

    public final void addLocationHint(SapphireActionLocationHint locationHint) {
        if (locationHint == null) {
            throw new IllegalArgumentException();
        }
        this.locationHints.add(locationHint);
        this.broadcast(new LocationHintsChangedEvent());
    }

    public final void removeLocationHint(String locationHint) {
        if (locationHint == null) {
            throw new IllegalArgumentException();
        }
        this.locationHints.remove(locationHint);
        this.broadcast(new LocationHintsChangedEvent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isVisible() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.visible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVisible(boolean visible) {
        boolean changed = false;
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            if (this.visible != visible) {
                this.visible = visible;
                changed = true;
            }
        }
        if (changed) {
            this.broadcast(new VisibilityEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setEnabled(boolean enabled) {
        boolean changed = false;
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            if (this.enabled != enabled) {
                this.enabled = enabled;
                changed = true;
            }
        }
        if (changed) {
            this.broadcast(new EnablementChangedEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChecked() {
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            return this.checked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setChecked(boolean checked) {
        boolean changed = false;
        SapphireActionSystemPart sapphireActionSystemPart = this;
        synchronized (sapphireActionSystemPart) {
            if (this.checked != checked) {
                this.checked = checked;
                changed = true;
            }
        }
        if (changed) {
            this.broadcast(new CheckedStateChangedEvent());
        }
    }

    public final boolean attach(Listener listener) {
        return this.listeners.attach(listener);
    }

    public final boolean detach(Listener listener) {
        return this.listeners.detach(listener);
    }

    protected final void broadcast(Event event) {
        this.listeners.broadcast(event);
    }

    public final void dispose() {
        if (this.labelFunctionResult != null) {
            this.labelFunctionResult.dispose();
        }
        this.broadcast((Event)new DisposeEvent());
    }

    public static final class CheckedStateChangedEvent
    extends Event {
    }

    public static final class EnablementChangedEvent
    extends Event {
    }

    public static final class IdChangedEvent
    extends Event {
    }

    public static final class ImagesChangedEvent
    extends Event {
    }

    public static final class LabelChangedEvent
    extends Event {
    }

    public static final class LocationHintsChangedEvent
    extends Event {
    }

    public static final class ToolTipChangedEvent
    extends Event {
    }

    public static final class VisibilityEvent
    extends Event {
    }
}

