/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.util.Collections;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.DelayedTasksExecutor;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphireDialogPart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.DialogDef;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireDialog
extends Dialog {
    private IModelElement element;
    private DefinitionLoader.Reference<DialogDef> definition;
    private SapphireDialogPart part;
    private Button okButton;

    public SapphireDialog(Shell shell, IModelElement element, DefinitionLoader.Reference<DialogDef> definition) {
        super(shell);
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.element = element;
        this.definition = definition;
        this.part = new SapphireDialogPart();
        this.part.init(null, this.element, this.definition.resolve(), Collections.<String, String>emptyMap());
    }

    public final IModelElement element() {
        return this.element;
    }

    public final DialogDef definition() {
        return this.definition.resolve();
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                SapphireDialog.this.element = null;
                SapphireDialog.this.part.dispose();
                SapphireDialog.this.part = null;
                SapphireDialog.this.definition.dispose();
                SapphireDialog.this.definition = null;
            }
        });
        shell.setText(this.part.getLabel());
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.part.getPreferFormStyle()) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        SapphireRenderingContext context = new SapphireRenderingContext((ISapphirePart)this.part, innerComposite);
        this.part.render(context);
        String initialFocusProperty = (String)this.part.definition().getInitialFocus().getContent();
        if (initialFocusProperty != null) {
            this.part.setFocus(initialFocusProperty);
        }
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        if (this.part.getPreferFormStyle()) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = (Composite)super.createButtonBar(parent);
        if (this.part.getPreferFormStyle()) {
            composite.setBackground(Display.getCurrent().getSystemColor(1));
        }
        this.okButton = this.getButton(0);
        this.part.attach((Listener)new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                SapphireDialog.this.updateOkButtonEnablement();
            }
        });
        this.updateOkButtonEnablement();
        return composite;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (this.part.getPreferFormStyle()) {
            button.setBackground(Display.getCurrent().getSystemColor(1));
        }
        return button;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        DelayedTasksExecutor.sweep();
        super.okPressed();
    }

    private void updateOkButtonEnablement() {
        boolean actual;
        boolean expected;
        if (!this.okButton.isDisposed() && (expected = this.part.validation().severity() != Status.Severity.ERROR) != (actual = this.okButton.isEnabled())) {
            this.okButton.setEnabled(expected);
        }
    }
}

