/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.ui.PartChildrenEvent;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.ConditionalDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConditionalPart
extends SapphirePart {
    private ConditionalDef def;
    private FunctionResult conditionFunctionResult;
    private List<SapphirePart> currentBranchContent;

    @Override
    protected void init() {
        super.init();
        this.def = (ConditionalDef)this.definition;
        this.conditionFunctionResult = this.initExpression(this.getModelElement(), (Function)this.def.getCondition().getContent(), Boolean.class, (Function)Literal.FALSE, new Runnable(){

            public void run() {
                ConditionalPart.this.handleConditionChanged();
            }
        });
        this.currentBranchContent = ListFactory.empty();
        this.handleConditionChanged(true);
    }

    private void handleConditionChanged() {
        this.handleConditionChanged(false);
    }

    private void handleConditionChanged(boolean initializing) {
        for (SapphirePart part : this.currentBranchContent) {
            part.dispose();
        }
        IModelElement element = this.getLocalModelElement();
        boolean newConditionState = (Boolean)this.conditionFunctionResult.value();
        ListFactory partsListFactory = ListFactory.start();
        FilteredListener<PartValidationEvent> childPartListener = new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                ConditionalPart.this.refreshValidation();
            }
        };
        for (PartDef childPartDef : newConditionState ? this.def.getThenContent() : this.def.getElseContent()) {
            SapphirePart part = ConditionalPart.create(this, element, childPartDef, this.params);
            part.attach((Listener)childPartListener);
            partsListFactory.add((Object)part);
        }
        this.currentBranchContent = partsListFactory.result();
        this.refreshValidation();
        if (!initializing) {
            this.broadcast(new PartChildrenEvent(this));
        }
    }

    public List<SapphirePart> getCurrentBranchContent() {
        return this.currentBranchContent;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        for (SapphirePart child : this.currentBranchContent) {
            child.render(context);
        }
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (SapphirePart child : this.currentBranchContent) {
            factory.merge(child.validation());
        }
        return factory.create();
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart child : this.currentBranchContent) {
            child.dispose();
        }
        if (this.conditionFunctionResult != null) {
            this.conditionFunctionResult.dispose();
        }
    }
}

