/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.xml.XmlAttribute;
import org.eclipse.sapphire.modeling.xml.XmlComment;
import org.eclipse.sapphire.modeling.xml.XmlMetaComment;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.util.IdentityCache;
import org.eclipse.sapphire.util.ListFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlElement
extends XmlNode {
    private final IdentityCache<Element, XmlElement> elementsCache = new IdentityCache();
    private final IdentityCache<Attr, XmlAttribute> attributesCache = new IdentityCache();
    private final IdentityCache<Comment, XmlComment> commentsCache = new IdentityCache();
    private final IdentityCache<Comment, XmlMetaComment> metaCommentsCache = new IdentityCache();
    private QName qname = null;
    private XmlContentModel contentModel = null;
    private boolean contentModelInitialized = false;

    public XmlElement(XmlResourceStore store, Element domElement) {
        this(store, null, domElement);
    }

    public XmlElement(XmlElement parent, Element domElement) {
        this(parent.getResourceStore(), parent, domElement);
    }

    private XmlElement(XmlResourceStore store, XmlElement parent, Element domElement) {
        super(store, parent, domElement);
    }

    @Override
    public Element getDomNode() {
        return (Element)super.getDomNode();
    }

    public String getLocalName() {
        return this.getDomNode().getLocalName();
    }

    public String getNamespace() {
        return this.getDomNode().getNamespaceURI();
    }

    public QName getQualifiedName() {
        if (this.qname == null) {
            this.qname = new QName(this.getNamespace(), this.getLocalName());
        }
        return this.qname;
    }

    public String getSchemaLocation() {
        String namespace = this.getNamespace();
        if (namespace != null) {
            Element root = this.getDomNode().getOwnerDocument().getDocumentElement();
            NamedNodeMap attributes = root.getAttributes();
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                Attr attr = (Attr)attributes.item(i);
                String attrLocalName = attr.getLocalName();
                if (attrLocalName != null && attrLocalName.equals("schemaLocation")) {
                    String[] segments = attr.getValue().split("[\\s]+");
                    boolean grabNextSegment = false;
                    int j = 0;
                    int m = segments.length;
                    while (j < m) {
                        if (j % 2 == 0) {
                            if (segments[j].equals(namespace)) {
                                grabNextSegment = true;
                            }
                        } else if (grabNextSegment) {
                            return segments[j];
                        }
                        ++j;
                    }
                    return namespace;
                }
                ++i;
            }
            return namespace;
        }
        return null;
    }

    public XmlContentModel getContentModel() {
        if (!this.contentModelInitialized) {
            XmlElement parent = this.getParent();
            if (parent == null) {
                XmlElementDefinition xmlElementDefinition;
                XmlDocumentSchema xmlDocumentSchema;
                DocumentType type;
                String schemaLocation = this.getSchemaLocation();
                String baseLocation = null;
                File file = this.getResourceStore().adapt(File.class);
                if (file != null) {
                    baseLocation = file.getAbsolutePath();
                }
                if (schemaLocation == null && (type = this.getDomNode().getOwnerDocument().getDoctype()) != null) {
                    schemaLocation = type.getSystemId();
                }
                if (schemaLocation != null && (xmlDocumentSchema = XmlDocumentSchemasCache.getSchema(schemaLocation, baseLocation)) != null && (xmlElementDefinition = xmlDocumentSchema.getElement(this.getLocalName())) != null) {
                    this.contentModel = xmlElementDefinition.getContentModel();
                }
            } else {
                XmlContentModel parentXmlContentModel = parent.getContentModel();
                if (parentXmlContentModel != null) {
                    this.contentModel = parentXmlContentModel.findChildElementContentModel(this.getQualifiedName());
                }
            }
            this.contentModelInitialized = true;
        }
        return this.contentModel;
    }

    @Override
    public String getText() {
        NodeList nodes = this.getDomNode().getChildNodes();
        String str = null;
        StringBuilder buf = null;
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 3 || nodeType == 4) {
                String val = node.getNodeValue();
                if (buf != null) {
                    buf.append(val);
                } else if (str != null) {
                    buf = new StringBuilder();
                    buf.append(str);
                    buf.append(val);
                    str = null;
                } else {
                    str = val;
                }
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return str != null ? str : "";
    }

    @Override
    public void setText(String elementText) {
        this.validateEdit();
        if (elementText == null) {
            elementText = "";
        }
        boolean isElementTextNonEmpty = elementText.length() > 0;
        Element domElement = this.getDomNode();
        NodeList elementChildren = domElement.getChildNodes();
        ArrayList<Node> removeList = new ArrayList<Node>();
        CharacterData text = null;
        int i = 0;
        int n = elementChildren.getLength();
        while (i < n) {
            Node child = elementChildren.item(i);
            if (text == null && child.getNodeType() == 3 && isElementTextNonEmpty) {
                text = (Text)child;
            } else {
                removeList.add(child);
            }
            ++i;
        }
        for (Node child : removeList) {
            domElement.removeChild(child);
        }
        if (isElementTextNonEmpty) {
            if (text != null) {
                text.setData(elementText);
            } else {
                domElement.appendChild(domElement.getOwnerDocument().createTextNode(elementText));
            }
        }
    }

    public List<XmlAttribute> getAttributes() {
        ListFactory result = ListFactory.start();
        NamedNodeMap attributes = this.getDomNode().getAttributes();
        this.attributesCache.track();
        int i = 0;
        int count = attributes.getLength();
        while (i < count) {
            Attr attribute = (Attr)attributes.item(i);
            XmlAttribute xmlAttribute = (XmlAttribute)this.attributesCache.get((Object)attribute);
            if (xmlAttribute == null) {
                xmlAttribute = new XmlAttribute(this, attribute);
                this.attributesCache.put((Object)attribute, (Object)xmlAttribute);
            }
            result.add((Object)xmlAttribute);
            ++i;
        }
        this.attributesCache.purge();
        return result.result();
    }

    public XmlAttribute getAttribute(String name, boolean createIfNecessary) {
        XmlAttribute attribute = null;
        for (XmlAttribute attr : this.getAttributes()) {
            if (!XmlElement.equal(attr.getLocalName(), name)) continue;
            attribute = attr;
            break;
        }
        if (attribute == null && createIfNecessary) {
            this.validateEdit();
            Element domElement = this.getDomNode();
            Attr attr = domElement.getOwnerDocument().createAttribute(name);
            domElement.setAttributeNode(attr);
            attribute = new XmlAttribute(this, attr);
            this.attributesCache.put((Object)attr, (Object)attribute);
        }
        return attribute;
    }

    public String getAttributeText(String name) {
        XmlAttribute attr = this.getAttribute(name, false);
        if (attr == null) {
            return "";
        }
        return attr.getText();
    }

    public void setAttributeText(String name, String value, boolean removeIfNullOrEmpty) {
        String val;
        this.validateEdit();
        String string = val = value == null ? "" : value;
        if (val.length() == 0) {
            XmlAttribute attr = this.getAttribute(name, false);
            if (attr != null) {
                if (removeIfNullOrEmpty) {
                    attr.remove();
                } else {
                    this.getAttribute(name, true).setText(val);
                }
            }
        } else {
            this.getAttribute(name, true).setText(val);
        }
    }

    public List<XmlElement> getChildElements() {
        ListFactory result = ListFactory.start();
        NodeList children = this.getDomNode().getChildNodes();
        this.elementsCache.track();
        int i = 0;
        int count = children.getLength();
        while (i < count) {
            Node n = children.item(i);
            if (n.getNodeType() == 1) {
                Element element = (Element)n;
                XmlElement xmlElement = (XmlElement)this.elementsCache.get((Object)element);
                if (xmlElement == null) {
                    xmlElement = new XmlElement(this, element);
                    this.elementsCache.put((Object)element, (Object)xmlElement);
                }
                result.add((Object)xmlElement);
            }
            ++i;
        }
        this.elementsCache.purge();
        return result.result();
    }

    public List<XmlElement> getChildElements(QName name) {
        ListFactory result = ListFactory.start();
        for (XmlElement element : this.getChildElements()) {
            if (!XmlElement.equal(MiscUtil.normalizeToNull((String)element.getNamespace()), MiscUtil.normalizeToNull((String)name.getNamespaceURI())) || !XmlElement.equal(element.getLocalName(), name.getLocalPart())) continue;
            result.add((Object)element);
        }
        return result.result();
    }

    public List<XmlElement> getChildElements(String name) {
        return this.getChildElements(this.createQualifiedName(name));
    }

    public XmlElement getChildElement(QName name, boolean createIfNecessary) {
        for (XmlElement element : this.getChildElements()) {
            if (!XmlElement.equal(MiscUtil.normalizeToNull((String)element.getNamespace()), MiscUtil.normalizeToNull((String)name.getNamespaceURI())) || !XmlElement.equal(element.getLocalName(), name.getLocalPart())) continue;
            return element;
        }
        if (createIfNecessary) {
            return this.addChildElement(name);
        }
        return null;
    }

    public XmlElement getChildElement(String name, boolean createIfNecessary) {
        return this.getChildElement(this.createQualifiedName(name), createIfNecessary);
    }

    public XmlElement addChildElement(QName name) {
        return this.addChildElement(name, (Node)null);
    }

    public XmlElement addChildElement(String name) {
        return this.addChildElement(this.createQualifiedName(name));
    }

    public XmlElement addChildElement(QName name, XmlElement refElement) {
        return this.addChildElement(name, refElement == null ? null : refElement.getDomNode());
    }

    public XmlElement addChildElement(String name, XmlElement refElement) {
        return this.addChildElement(this.createQualifiedName(name), refElement);
    }

    private XmlElement addChildElement(QName name, Node refNode) {
        Element element;
        String namespace;
        int position;
        XmlContentModel xmlContentModel;
        this.validateEdit();
        Element domElement = this.getDomNode();
        Document document = domElement.getOwnerDocument();
        NodeList siblings = domElement.getChildNodes();
        int siblingsCount = siblings.getLength();
        this.notifyPreChildElementAddListeners();
        Node refNodeRevised = refNode;
        if (refNodeRevised == null && (xmlContentModel = this.getContentModel()) != null && (position = xmlContentModel.findInsertionPosition(siblings, name)) < siblingsCount) {
            refNodeRevised = siblings.item(position);
        }
        Node prevNode = null;
        if (refNodeRevised == null) {
            if (siblingsCount > 0) {
                prevNode = siblings.item(siblingsCount - 1);
            }
        } else {
            prevNode = refNodeRevised.getPreviousSibling();
        }
        if (prevNode != null && prevNode.getNodeType() == 3 && prevNode.getNodeValue().trim().length() == 0) {
            refNodeRevised = prevNode;
        }
        if ((namespace = name.getNamespaceURI()) == null || namespace.length() == 0) {
            element = document.createElementNS(null, name.getLocalPart());
        } else {
            String prefix = this.findNamespacePrefix(namespace, name.getPrefix());
            String qname = prefix == null || prefix.length() == 0 ? name.getLocalPart() : String.valueOf(prefix) + ":" + name.getLocalPart();
            element = document.createElementNS(namespace, qname);
        }
        domElement.insertBefore(element, refNodeRevised);
        XmlElement wrappedElement = new XmlElement(this, element);
        this.elementsCache.put((Object)element, (Object)wrappedElement);
        if (domElement.getNodeType() == 1 && domElement.getChildNodes().getLength() == 1) {
            this.format();
        } else {
            wrappedElement.format();
        }
        this.notifyPostChildElementAddListeners();
        return wrappedElement;
    }

    private String findNamespacePrefix(String namespace, String defaultPrefix) {
        Element domElement = this.getDomNode();
        String prefix = null;
        if (namespace != null && namespace.length() > 0) {
            String ns = this.getNamespace();
            if (ns != null && ns.equals(namespace)) {
                prefix = domElement.getPrefix();
            } else {
                HashMap<String, String> namespaces = new HashMap<String, String>();
                Element el = domElement;
                boolean found = false;
                while (el != null && !found) {
                    NamedNodeMap attributes = el.getAttributes();
                    int i = 0;
                    int n = attributes.getLength();
                    while (i < n) {
                        Attr attr = (Attr)attributes.item(i);
                        String attrName = attr.getName();
                        String attrValue = attr.getValue();
                        if (attrName.equals("xmlns")) {
                            if (attrValue.equals(namespace)) {
                                found = true;
                                break;
                            }
                            namespaces.put("", attrValue);
                        } else if (attrName.startsWith("xmlns:")) {
                            String p = attrName.substring(6);
                            if (attrValue.equals(namespace)) {
                                prefix = p;
                                found = true;
                                break;
                            }
                            namespaces.put(p, attrValue);
                        }
                        ++i;
                    }
                    Node parent = el.getParentNode();
                    el = parent instanceof Element ? (Element)parent : null;
                }
                if (!found) {
                    prefix = defaultPrefix;
                    int i = 1;
                    while (namespaces.containsKey(prefix)) {
                        prefix = String.valueOf(defaultPrefix) + String.valueOf(i);
                        ++i;
                    }
                    String xmlnsAttrName = "xmlns:" + prefix;
                    Element root = domElement.getOwnerDocument().getDocumentElement();
                    root.setAttribute(xmlnsAttrName, namespace);
                    if (!namespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                        XmlContentModel xmlContentModel = this.getContentModel();
                        String schemaLocation = null;
                        if (xmlContentModel != null) {
                            schemaLocation = xmlContentModel.getSchema().getSchemaLocation(namespace);
                        }
                        this.addSchemaLocation(namespace, schemaLocation);
                    }
                }
            }
        }
        return prefix;
    }

    private void addSchemaLocation(String namespace, String schemaLocation) {
        if (schemaLocation != null && !namespace.equals(schemaLocation)) {
            String xsiNamespacePrefix = this.findNamespacePrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            String schemaLocationAttrName = xsiNamespacePrefix == null ? "schemaLocation" : String.valueOf(xsiNamespacePrefix) + ":schemaLocation";
            Element root = this.getDomNode().getOwnerDocument().getDocumentElement();
            String existingSchemaLocations = root.getAttribute(schemaLocationAttrName);
            LinkedHashMap<String, String> schemaLocations = new LinkedHashMap<String, String>();
            if (existingSchemaLocations != null && existingSchemaLocations.length() > 0) {
                String ns = null;
                String[] stringArray = existingSchemaLocations.split("[\\s]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    if (ns == null) {
                        ns = segment;
                    } else {
                        schemaLocations.put(ns, segment);
                        ns = null;
                    }
                    ++n2;
                }
            }
            schemaLocations.put(namespace, schemaLocation);
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : schemaLocations.entrySet()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append((String)entry.getKey());
                buf.append(' ');
                buf.append((String)entry.getValue());
            }
            root.setAttribute(schemaLocationAttrName, buf.toString());
        }
    }

    public XmlNode getChildNode(XmlPath path, boolean createIfNecessary) {
        XmlElement el = this;
        for (XmlPath.Segment segment : path.getSegments()) {
            XmlNode node = el.getChildNode(segment, createIfNecessary);
            if (node instanceof XmlElement) {
                el = (XmlElement)node;
                continue;
            }
            return node;
        }
        return el;
    }

    public XmlNode getChildNode(XmlPath.Segment pathSegment, boolean createIfNecessary) {
        XmlPath.Segment resolvedPathSegment = this.resolveXmlPathSegment(pathSegment);
        QName qname = resolvedPathSegment.getQualifiedName();
        if (resolvedPathSegment.isAttribute()) {
            return this.getAttribute(qname.getLocalPart(), createIfNecessary);
        }
        if (resolvedPathSegment.isComment()) {
            return this.getMetaComment(qname.getLocalPart(), createIfNecessary);
        }
        return this.getChildElement(qname, createIfNecessary);
    }

    public String getChildNodeText(XmlPath path) {
        XmlNode node = this.getChildNode(path, false);
        if (node != null) {
            return node.getText();
        }
        return "";
    }

    public String getChildNodeText(String path) {
        return this.getChildNodeText(new XmlPath(path));
    }

    public void setChildNodeText(XmlPath path, String text, boolean removeIfNullOrEmpty) {
        this.validateEdit();
        if (removeIfNullOrEmpty && (text == null || text.trim().length() == 0) && path.getSegmentCount() > 0) {
            this.removeChildNode(path);
        } else {
            this.getChildNode(path, true).setText(text);
        }
    }

    public void setChildNodeText(String path, String text, boolean removeIfNullOrEmpty) {
        this.setChildNodeText(new XmlPath(path), text, removeIfNullOrEmpty);
    }

    public void removeChildNode(String path) {
        this.removeChildNode(new XmlPath(path));
    }

    public void removeChildNode(XmlPath path) {
        this.removeChildNode(this, path, 0);
    }

    private void removeChildNode(XmlElement el, XmlPath path, int pathPosition) {
        this.validateEdit();
        XmlPath.Segment segment = path.getSegment(pathPosition);
        XmlNode child = el.getChildNode(segment, false);
        if (child != null) {
            if (pathPosition == path.getSegmentCount() - 1) {
                child.remove();
            } else if (child instanceof XmlElement) {
                XmlElement childElement = (XmlElement)child;
                this.removeChildNode(childElement, path, pathPosition + 1);
                if (childElement.isEmpty()) {
                    childElement.remove();
                }
            }
        }
    }

    public void move(XmlElement ref) {
        if (this != ref) {
            this.validateEdit();
            Element domElement = this.getDomNode();
            Node domParentNode = domElement.getParentNode();
            ListFactory domNodesToMove = ListFactory.start();
            domNodesToMove.add((Object)domElement);
            Node prev = domElement.getPreviousSibling();
            while (prev != null && prev.getNodeType() == 3 && prev.getNodeValue().trim().length() == 0) {
                domNodesToMove.add((Object)prev);
                prev = prev.getPreviousSibling();
            }
            Node domRefNode = ref.getDomNode();
            Node prev2 = domRefNode.getPreviousSibling();
            while (prev2 != null && prev2.getNodeType() == 3 && prev2.getNodeValue().trim().length() == 0) {
                domRefNode = prev2;
                prev2 = prev2.getPreviousSibling();
            }
            for (Node node : domNodesToMove.result()) {
                domParentNode.removeChild(node);
                domParentNode.insertBefore(node, domRefNode);
                domRefNode = node;
            }
        }
    }

    public void swap(XmlElement y) {
        this.validateEdit();
        Element domElement = this.getDomNode();
        Node parent = domElement.getParentNode();
        Document document = parent.getOwnerDocument();
        Text xBookmark = document.createTextNode("");
        parent.insertBefore(xBookmark, domElement);
        Text yBookmark = document.createTextNode("");
        parent.insertBefore(yBookmark, y.getDomNode());
        parent.removeChild(domElement);
        parent.removeChild(y.getDomNode());
        parent.insertBefore(domElement, yBookmark);
        parent.insertBefore(y.getDomNode(), xBookmark);
        parent.removeChild(xBookmark);
        parent.removeChild(yBookmark);
    }

    @Override
    public void remove() {
        this.validateEdit();
        Element domElement = this.getDomNode();
        Node parentDomNode = domElement.getParentNode();
        if (parentDomNode != null) {
            XmlElement parentXmlElement = this.getParent();
            if (parentXmlElement != null) {
                parentXmlElement.notifyPreChildElementRemoveListeners();
            }
            Node previousSibling = domElement.getPreviousSibling();
            parentDomNode.removeChild(domElement);
            if (previousSibling != null && previousSibling.getNodeType() == 3 && previousSibling.getNodeValue().trim().length() == 0) {
                parentDomNode.removeChild(previousSibling);
            }
            if (parentXmlElement != null) {
                parentXmlElement.notifyPostChildElementRemoveListeners();
            }
        }
    }

    public boolean isEmpty() {
        Element node = this.getDomNode();
        if (node.hasAttributes()) {
            return false;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            if (child.getNodeType() != 3 || child.getNodeValue().trim().length() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public List<XmlComment> getComments() {
        ListFactory result = ListFactory.start();
        NodeList children = this.getDomNode().getChildNodes();
        this.commentsCache.track();
        int i = 0;
        int count = children.getLength();
        while (i < count) {
            Node n = children.item(i);
            if (n.getNodeType() == 8) {
                Comment comment = (Comment)n;
                XmlComment xmlComment = (XmlComment)this.commentsCache.get((Object)comment);
                if (xmlComment == null) {
                    xmlComment = new XmlComment(this, comment);
                    this.commentsCache.put((Object)comment, (Object)xmlComment);
                }
                result.add((Object)xmlComment);
            }
            ++i;
        }
        this.commentsCache.purge();
        return result.result();
    }

    public XmlComment addComment(String commentText) {
        Node prevChild;
        this.validateEdit();
        Element domElement = this.getDomNode();
        Document document = domElement.getOwnerDocument();
        NodeList nodes = domElement.getChildNodes();
        int position = 0;
        int n = nodes.getLength();
        while (position < n) {
            Node child = nodes.item(position);
            if (child.getNodeType() != 8 && child.getNodeType() != 3) break;
            ++position;
        }
        Node refChild = position < nodes.getLength() ? nodes.item(position) : null;
        int prevPosition = position - 1;
        Node node = prevChild = prevPosition < nodes.getLength() ? nodes.item(prevPosition) : null;
        if (prevChild != null && prevChild.getNodeType() == 3 && prevChild.getNodeValue().trim().length() == 0) {
            refChild = prevChild;
            position = prevPosition;
        }
        prevChild = (prevPosition = position - 1) < nodes.getLength() ? nodes.item(prevPosition) : null;
        Comment comment = document.createComment(commentText);
        domElement.insertBefore(comment, refChild);
        XmlComment wrappedComment = new XmlComment(this, comment);
        this.commentsCache.put((Object)comment, (Object)wrappedComment);
        if (domElement.getNodeType() == 1 && domElement.getChildNodes().getLength() == 1) {
            this.format();
        } else {
            wrappedComment.format();
        }
        return wrappedComment;
    }

    public List<XmlMetaComment> getMetaComments() {
        ListFactory result = ListFactory.start();
        NodeList children = this.getDomNode().getChildNodes();
        this.metaCommentsCache.track();
        int i = 0;
        int count = children.getLength();
        while (i < count) {
            Node n = children.item(i);
            if (n.getNodeType() == 8 && n.getNodeValue().indexOf(58) != -1) {
                Comment metaComment = (Comment)n;
                XmlMetaComment xmlMetaComment = (XmlMetaComment)this.metaCommentsCache.get((Object)metaComment);
                if (xmlMetaComment == null) {
                    xmlMetaComment = new XmlMetaComment(this, metaComment);
                    this.metaCommentsCache.put((Object)metaComment, (Object)xmlMetaComment);
                }
                result.add((Object)xmlMetaComment);
            }
            ++i;
        }
        this.metaCommentsCache.purge();
        return result.result();
    }

    public XmlMetaComment getMetaComment(String name, boolean createIfNecessary) {
        XmlMetaComment xmlMetaComment = null;
        for (XmlMetaComment x : this.getMetaComments()) {
            if (!XmlElement.equal(x.getName(), name)) continue;
            xmlMetaComment = x;
            break;
        }
        if (xmlMetaComment == null && createIfNecessary) {
            Comment comment = this.addComment(String.valueOf(name) + ":").getDomNode();
            xmlMetaComment = new XmlMetaComment(this, comment);
            this.metaCommentsCache.put((Object)comment, (Object)xmlMetaComment);
        }
        return xmlMetaComment;
    }

    public String getMetaCommentText(String name) {
        XmlMetaComment comment = this.getMetaComment(name, false);
        if (comment != null) {
            return comment.getText();
        }
        return null;
    }

    public void setMetaCommentText(String name, String value) {
        this.validateEdit();
        if (value != null && value.length() == 0) {
            value = null;
        }
        XmlMetaComment comment = this.getMetaComment(name, true);
        if (value != null) {
            comment.setText(value);
        } else {
            comment.remove();
        }
    }

    private XmlPath.Segment resolveXmlPathSegment(XmlPath.Segment pathSegment) {
        String namespace = pathSegment.getQualifiedName().getNamespaceURI();
        if (pathSegment.isAttribute() || pathSegment.isComment() || namespace.length() != 0) {
            return pathSegment;
        }
        String prefix = pathSegment.getQualifiedName().getPrefix();
        if (prefix.length() == 0) {
            namespace = this.getDomNode().getNamespaceURI();
        }
        QName newQualifiedName = new QName(namespace, pathSegment.getQualifiedName().getLocalPart(), prefix);
        return new XmlPath.Segment(newQualifiedName, false, false);
    }

    private QName createQualifiedName(String localName) {
        String namespace = this.getDomNode().getNamespaceURI();
        return new QName(namespace, localName);
    }

    private static final boolean equal(Object obj1, Object obj2) {
        boolean objectsAreEqual = false;
        if (obj1 == obj2) {
            objectsAreEqual = true;
        } else if (obj1 != null && obj2 != null) {
            objectsAreEqual = obj1.equals(obj2);
        }
        return objectsAreEqual;
    }

    protected final void notifyPreChildElementAddListeners() {
        this.notifyListeners(new XmlNode.Event(XmlNode.EventType.PRE_CHILD_ELEMENT_ADD, this));
    }

    protected final void notifyPostChildElementAddListeners() {
        this.notifyListeners(new XmlNode.Event(XmlNode.EventType.POST_CHILD_ELEMENT_ADD, this));
    }

    protected final void notifyPreChildElementRemoveListeners() {
        this.notifyListeners(new XmlNode.Event(XmlNode.EventType.PRE_CHILD_ELEMENT_REMOVE, this));
    }

    protected final void notifyPostChildElementRemoveListeners() {
        this.notifyListeners(new XmlNode.Event(XmlNode.EventType.POST_CHILD_ELEMENT_REMOVE, this));
    }
}

