/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.util.SortedSet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.modeling.ElementBindingImpl;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.ElementValidationEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.ValidationAggregationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementHandle<T extends IModelElement> {
    private final ModelElement parent;
    private final ElementProperty property;
    private final PossibleTypesService possibleTypesService;
    private final ElementBindingImpl binding;
    private T element;
    private Boolean enablement;
    private Status validationStateLocal;
    private Status validationStatetFull;

    public ModelElementHandle(IModelElement parent, ElementProperty property) {
        this.parent = (ModelElement)parent;
        this.property = property;
        this.possibleTypesService = parent.service(property, PossibleTypesService.class);
        this.binding = parent.resource().binding(property);
    }

    public void init() {
        this.refresh(false);
    }

    public IModelElement root() {
        return (IModelElement)this.parent.root();
    }

    public IModelElement parent() {
        return this.parent;
    }

    public T element() {
        return this.element(false);
    }

    public T element(boolean createIfNecessary) {
        if (createIfNecessary) {
            SortedSet<ModelElementType> possible = this.possibleTypesService.types();
            if (possible.size() > 1) {
                throw new IllegalArgumentException();
            }
            return this.element(true, possible.first());
        }
        return this.element(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T element(boolean createIfNecessary, ModelElementType type) {
        SortedSet<ModelElementType> possible = this.possibleTypesService.types();
        if (type != null && !possible.contains(type)) {
            throw new IllegalArgumentException();
        }
        boolean changed = false;
        if (createIfNecessary) {
            ModelElementType t = type;
            if (t == null) {
                if (possible.size() > 1) {
                    throw new IllegalArgumentException();
                }
                t = possible.first();
            }
            ModelElementHandle modelElementHandle = this;
            synchronized (modelElementHandle) {
                if (this.element == null) {
                    this.refresh();
                }
                if (this.element == null || this.element.type() != t) {
                    Resource resource = this.binding.create(t);
                    this.element = t.instantiate(this.parent, this.property, resource);
                    this.element.initialize();
                    this.element.attach(new FilteredListener<ElementValidationEvent>(){

                        @Override
                        protected void handleTypedEvent(ElementValidationEvent event) {
                            ModelElementHandle.this.refreshValidation(true);
                        }
                    });
                    changed = true;
                }
            }
        }
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            if (this.element != null && type != null && this.element.type() != type) {
                throw new IllegalArgumentException();
            }
        }
        if (changed) {
            if (!(this.property instanceof ImpliedElementProperty)) {
                this.parent.broadcastPropertyContentEvent(this.property);
            }
            this.refreshValidation(true);
        }
        return this.element;
    }

    public Status validation() {
        return this.validation(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status validation(boolean includeChildValidation) {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            if (this.validationStatetFull == null) {
                this.refreshValidation(false);
            }
            return includeChildValidation ? this.validationStatetFull : this.validationStateLocal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enabled() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            if (this.enablement == null) {
                this.refreshEnablement(false);
            }
            return this.enablement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            boolean changed = false;
            if (this.element != null) {
                this.binding.remove();
                changed = this.refresh();
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removable() {
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            return this.binding.removable();
        }
    }

    public boolean refresh() {
        return this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refresh(boolean broadcastChangeIfNecessary) {
        boolean changed = false;
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            Resource oldResource = this.element == null ? null : this.element.resource();
            Resource newResource = this.binding.read();
            if (newResource != oldResource) {
                T toBeDisposed = this.element;
                if (newResource == null) {
                    this.element = null;
                } else {
                    ModelElementType type = this.binding.type(newResource);
                    this.element = type.instantiate(this.parent, this.property, newResource);
                    this.element.attach(new FilteredListener<ElementValidationEvent>(){

                        @Override
                        protected void handleTypedEvent(ElementValidationEvent event) {
                            ModelElementHandle.this.refreshValidation(true);
                        }
                    });
                }
                if (toBeDisposed != null) {
                    try {
                        toBeDisposed.dispose();
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                    }
                }
                changed = true;
            }
        }
        if (changed && broadcastChangeIfNecessary && !(this.property instanceof ImpliedElementProperty)) {
            this.parent.broadcastPropertyContentEvent(this.property);
        }
        changed = changed | this.refreshEnablement(broadcastChangeIfNecessary) | this.refreshValidation(broadcastChangeIfNecessary);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshEnablement(boolean broadcastChangeIfNecessary) {
        boolean changed = false;
        boolean before = false;
        boolean after = false;
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            boolean newEnablementState = true;
            for (EnablementService service : this.parent().services(this.property, EnablementService.class)) {
                boolean bl = newEnablementState = newEnablementState && service.enablement();
                if (!newEnablementState) break;
            }
            if (this.enablement == null) {
                this.enablement = newEnablementState;
            } else if (this.enablement != newEnablementState) {
                changed = true;
                before = this.enablement;
                after = newEnablementState;
                this.enablement = newEnablementState;
            }
        }
        if (changed && broadcastChangeIfNecessary) {
            ((ModelElement)this.parent()).broadcastPropertyEnablementEvent(this.property, before, after);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshValidation(boolean broadcastChangeIfNecessary) {
        boolean changed = false;
        Status before = null;
        Status after = null;
        ModelElementHandle modelElementHandle = this;
        synchronized (modelElementHandle) {
            Status oldValidationResultFull;
            Status newValidationResultFull;
            Status newValidationResultLocal = this.parent().service(this.property, ValidationAggregationService.class).validation();
            Status.CompositeStatusFactory newValidationResultFullFactory = Status.factoryForComposite();
            newValidationResultFullFactory.merge(newValidationResultLocal);
            if (this.element != null) {
                newValidationResultFullFactory.merge(this.element.validation());
            }
            if (!(newValidationResultFull = newValidationResultFullFactory.create()).equals(oldValidationResultFull = this.validationStatetFull)) {
                this.validationStateLocal = newValidationResultLocal;
                this.validationStatetFull = newValidationResultFull;
                if (oldValidationResultFull != null) {
                    changed = true;
                    before = oldValidationResultFull;
                    after = this.validationStatetFull;
                }
            }
        }
        if (changed && broadcastChangeIfNecessary) {
            ((ModelElement)this.parent()).broadcastPropertyValidationEvent(this.property, before, after);
        }
        return changed;
    }
}

