/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelParticle
implements IModelParticle {
    private final IModelParticle parent;
    private final Resource resource;

    public ModelParticle(IModelParticle parent, Resource resource) {
        this.parent = parent;
        this.resource = resource;
    }

    @Override
    public final Resource resource() {
        return this.resource;
    }

    @Override
    public final IModelParticle root() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.root();
    }

    @Override
    public IModelParticle parent() {
        return this.parent;
    }

    @Override
    public final <T> T nearest(Class<T> particleType) {
        if (particleType.isAssignableFrom(this.getClass())) {
            return particleType.cast(this);
        }
        if (this.parent != null) {
            return this.parent.nearest(particleType);
        }
        return null;
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        A result = null;
        if (this.resource != null) {
            result = this.resource.adapt(adapterType);
        }
        if (result == null && this.parent != null) {
            result = this.parent.adapt(adapterType);
        }
        if (result == null && adapterType == LocalizationService.class) {
            result = adapterType.cast(SourceLanguageLocalizationService.INSTANCE);
        }
        return result;
    }
}

