/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataService<T>
extends Service {
    private T data;
    private boolean initialized;
    private boolean readPriorToInit;

    @Override
    protected final void init() {
        this.initDataService();
        this.refresh();
        this.initialized = true;
    }

    protected void initDataService() {
    }

    public T data() {
        if (!this.initialized) {
            this.readPriorToInit = true;
        }
        return this.data;
    }

    protected abstract T compute();

    protected final void refresh() {
        T newData = this.compute();
        if (!MiscUtil.equal(this.data, newData)) {
            this.data = newData;
            if (this.initialized || this.readPriorToInit) {
                this.broadcast();
            }
        }
    }
}

