/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.ValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueValueValidationService
extends ValidationService {
    @Override
    public Status validate() {
        Value value = (Value)this.context(IModelElement.class).read(this.context(ModelProperty.class));
        if (!this.isUniqueValue(value)) {
            ValueProperty property = value.getProperty();
            String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
            String str = value.getText();
            String msg = NLS.bind(Resources.message, label, str);
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    protected boolean isUniqueValue(Value<?> value) {
        String str = value.getText();
        if (str != null) {
            IModelElement modelElement = value.parent();
            ValueProperty property = value.getProperty();
            IModelParticle parent = modelElement.parent();
            if (parent instanceof ModelElementList) {
                ModelElementList list = (ModelElementList)parent;
                for (IModelElement x : list) {
                    Value xval;
                    if (x == modelElement || !str.equals((xval = x.read(property)).getText())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String message;

        static {
            Resources.initializeMessages(UniqueValueValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

