/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileExtensions;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.FileExtensionsServiceData;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class DeclarativeFileExtensionsService
extends FileExtensionsService {
    private FunctionResult functionResult;

    protected void initFileExtensionsService() {
        FileExtensions fileExtensionsAnnotation = this.context(ModelProperty.class).getAnnotation(FileExtensions.class);
        Function function = null;
        try {
            function = ExpressionLanguageParser.parse(fileExtensionsAnnotation.expr());
        }
        catch (Exception e) {
            LoggingService.log(e);
            function = null;
        }
        if (function != null) {
            function = FailSafeFunction.create(function, Literal.create(List.class), Literal.create(Collections.emptyList()));
            this.functionResult = function.evaluate(new ModelElementFunctionContext(this.context(IModelElement.class)));
            this.functionResult.attach(new Listener(){

                public void handle(Event event) {
                    DeclarativeFileExtensionsService.this.refresh();
                }
            });
        }
    }

    protected FileExtensionsServiceData compute() {
        ArrayList<String> extensions = new ArrayList<String>();
        if (this.functionResult != null) {
            for (Object extension : (List)this.functionResult.value()) {
                extensions.add((String)extension);
            }
        }
        return new FileExtensionsServiceData(extensions);
    }

    public void dispose() {
        super.dispose();
        if (this.functionResult != null) {
            try {
                this.functionResult.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(FileExtensions.class);
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new DeclarativeFileExtensionsService();
        }
    }
}

