/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumericRangeValidationService<T extends Comparable<T>>
extends ValidationService {
    private final T min;
    private final T max;

    public NumericRangeValidationService(T minValue, T maxValue) {
        this.min = minValue;
        this.max = maxValue;
    }

    @Override
    public Status validate() {
        Value value = this.context(IModelElement.class).read(this.context(ValueProperty.class));
        Comparable val = (Comparable)value.getContent(true);
        if (val != null) {
            ValueProperty property = value.getProperty();
            if (this.min != null && val.compareTo(this.min) < 0) {
                String msg = NLS.bind(Resources.smallerThanMinimumMessage, val, this.normalizeForDisplay(property, this.min));
                return Status.createErrorStatus(msg);
            }
            if (this.max != null && val.compareTo(this.max) > 0) {
                String msg = NLS.bind(Resources.largerThanMaxiumMessage, val, this.normalizeForDisplay(property, this.max));
                return Status.createErrorStatus(msg);
            }
        }
        return Status.createOkStatus();
    }

    private String normalizeForDisplay(ValueProperty property, T value) {
        String result = property.encodeKeywords(value.toString());
        ValueKeyword keyword = property.getKeyword(result);
        if (keyword != null) {
            result = keyword.toDisplayString();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(NumericRange.class) && Number.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            ModelProperty property = context.find(ModelProperty.class);
            Class<?> type = property.getTypeClass();
            NumericRange rangeConstraintAnnotation = property.getAnnotation(NumericRange.class);
            String minStr = rangeConstraintAnnotation.min();
            String maxStr = rangeConstraintAnnotation.max();
            if (minStr != null || maxStr != null) {
                try {
                    if (Integer.class.isAssignableFrom(type)) {
                        Integer min = minStr.length() > 0 ? Integer.valueOf(minStr) : null;
                        Integer max = maxStr.length() > 0 ? Integer.valueOf(maxStr) : null;
                        return new NumericRangeValidationService<Integer>(min, max);
                    }
                    if (Long.class.isAssignableFrom(type)) {
                        Long min = minStr.length() > 0 ? Long.valueOf(minStr) : null;
                        Long max = maxStr.length() > 0 ? Long.valueOf(maxStr) : null;
                        return new NumericRangeValidationService<Long>(min, max);
                    }
                    if (Float.class.isAssignableFrom(type)) {
                        Float min = minStr.length() > 0 ? Float.valueOf(minStr) : null;
                        Float max = maxStr.length() > 0 ? Float.valueOf(maxStr) : null;
                        return new NumericRangeValidationService<Float>(min, max);
                    }
                    if (Double.class.isAssignableFrom(type)) {
                        Double min = minStr.length() > 0 ? Double.valueOf(minStr) : null;
                        Double max = maxStr.length() > 0 ? Double.valueOf(maxStr) : null;
                        return new NumericRangeValidationService<Double>(min, max);
                    }
                    if (BigInteger.class.isAssignableFrom(type)) {
                        BigInteger min = minStr.length() > 0 ? new BigInteger(minStr) : null;
                        BigInteger max = maxStr.length() > 0 ? new BigInteger(maxStr) : null;
                        return new NumericRangeValidationService<BigInteger>(min, max);
                    }
                    if (BigDecimal.class.isAssignableFrom(type)) {
                        BigDecimal min = minStr.length() > 0 ? new BigDecimal(minStr) : null;
                        BigDecimal max = maxStr.length() > 0 ? new BigDecimal(maxStr) : null;
                        return new NumericRangeValidationService<BigDecimal>(min, max);
                    }
                }
                catch (NumberFormatException e) {
                    LoggingService.log(e);
                }
            }
            return null;
        }
    }

    private static final class Resources
    extends NLS {
        public static String smallerThanMinimumMessage;
        public static String largerThanMaxiumMessage;

        static {
            Resources.initializeMessages(NumericRangeValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

