/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.events.t0005;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.internal.MemoryResource;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.events.EventLog;
import org.eclipse.sapphire.tests.modeling.events.t0005.RootElement;

public final class TestModelingEvents0005
extends SapphireTestCase {
    private TestModelingEvents0005(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestModelingEvents0005");
        suite.addTest((Test)new TestModelingEvents0005("testInitializationEventDuringEnablementCheck_ValueProperty"));
        suite.addTest((Test)new TestModelingEvents0005("testInitializationEventDuringEnablementCheck_ElementProperty"));
        suite.addTest((Test)new TestModelingEvents0005("testInitializationEventDuringEnablementCheck_ImpliedElementProperty"));
        suite.addTest((Test)new TestModelingEvents0005("testInitializationEventDuringEnablementCheck_ListProperty"));
        return suite;
    }

    public void testInitializationEventDuringEnablementCheck_ValueProperty() throws Exception {
        this.test((ModelProperty)RootElement.PROP_VALUE);
    }

    public void testInitializationEventDuringEnablementCheck_ElementProperty() throws Exception {
        this.test((ModelProperty)RootElement.PROP_ELEMENT);
    }

    public void testInitializationEventDuringEnablementCheck_ImpliedElementProperty() throws Exception {
        this.test((ModelProperty)RootElement.PROP_IMPLIED_ELEMENT);
    }

    public void testInitializationEventDuringEnablementCheck_ListProperty() throws Exception {
        this.test((ModelProperty)RootElement.PROP_LIST);
    }

    private void test(ModelProperty property) throws Exception {
        RootElement root = (RootElement)RootElement.TYPE.instantiate((Resource)new MemoryResource(RootElement.TYPE));
        EventLog log = new EventLog();
        root.attach(log);
        root.enabled(property);
        TestModelingEvents0005.assertPropertyInitializationEvent(log.event(0), root, (ModelProperty)RootElement.PROP_ENABLED);
        TestModelingEvents0005.assertPropertyInitializationEvent(log.event(1), root, property);
        log.clear();
        root.setEnabled(false);
        TestModelingEvents0005.assertPropertyContentEvent(log.event(0), root, (ModelProperty)RootElement.PROP_ENABLED);
        TestModelingEvents0005.assertPropertyEnablementEvent(log.event(log.size() - 1), root, property, true, false);
    }
}

