/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.List;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.SapphireWizardPagePart;
import org.eclipse.sapphire.ui.def.WizardDef;
import org.eclipse.sapphire.ui.def.WizardPageDef;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireWizardPart
extends SapphirePart {
    private FunctionResult imageFunctionResult;
    private List<SapphireWizardPagePart> pages;

    @Override
    protected void init() {
        super.init();
        IModelElement element = this.getModelElement();
        WizardDef def = this.definition();
        this.imageFunctionResult = this.initExpression(element, (Function)def.getImage().getContent(), ImageData.class, null, new Runnable(){

            public void run() {
                SapphireWizardPart.this.broadcast(new SapphirePart.ImageChangedEvent(SapphireWizardPart.this));
            }
        });
        ListFactory pagesListFactory = ListFactory.start();
        for (WizardPageDef pageDef : def.getPages()) {
            pagesListFactory.add((Object)((SapphireWizardPagePart)SapphireWizardPart.create(this, element, pageDef, this.params)));
        }
        this.pages = pagesListFactory.result();
    }

    @Override
    public WizardDef definition() {
        return (WizardDef)super.definition();
    }

    public String getLabel() {
        return this.definition().getLabel().getLocalizedText(CapitalizationType.TITLE_STYLE, false);
    }

    public String getDescription() {
        return this.definition().getDescription().getLocalizedText(CapitalizationType.NO_CAPS, false);
    }

    public ImageData getImage() {
        return (ImageData)this.imageFunctionResult.value();
    }

    public List<SapphireWizardPagePart> getPages() {
        return this.pages;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        if (this.imageFunctionResult != null) {
            this.imageFunctionResult.dispose();
        }
        for (SapphireWizardPagePart page : this.pages) {
            page.dispose();
        }
        super.dispose();
    }
}

