/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Context {
    public static final Context adapt(ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException();
        }
        return new ClassLoaderContext(loader);
    }

    public static final Context adapt(Class<?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException();
        }
        return new ClassContext(cl);
    }

    public abstract <T> Class<T> findClass(String var1);

    public abstract URL findResource(String var1);

    public abstract List<URL> findResources(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassContext
    extends ClassLoaderContext {
        private final String pkg;
        private final String path;

        public ClassContext(Class<?> cl) {
            super(cl.getClassLoader());
            Package pkg = cl.getPackage();
            if (pkg == null) {
                this.pkg = null;
                this.path = null;
            } else {
                this.pkg = pkg.getName();
                this.path = this.pkg.replace('.', '/');
            }
        }

        @Override
        public <T> Class<T> findClass(String name) {
            Class cl = super.findClass(name);
            if (cl == null && name.indexOf(46) == -1 && this.pkg != null) {
                cl = super.findClass(String.valueOf(this.pkg) + "." + name);
            }
            return cl;
        }

        @Override
        public URL findResource(String name) {
            URL resource = super.findResource(name);
            if (resource == null && name.indexOf(47) == -1 && this.path != null) {
                resource = super.findResource(String.valueOf(this.path) + "/" + name);
            }
            return resource;
        }

        @Override
        public List<URL> findResources(String name) {
            List<URL> resources = super.findResources(name);
            if (resources.isEmpty() && name.indexOf(47) == -1 && this.path != null) {
                resources = super.findResources(String.valueOf(this.path) + "/" + name);
            }
            return resources;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassLoaderContext
    extends Context {
        private final ClassLoader loader;

        public ClassLoaderContext(ClassLoader loader) {
            this.loader = loader;
        }

        @Override
        public <T> Class<T> findClass(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            try {
                return this.loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        @Override
        public URL findResource(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            return this.loader.getResource(name);
        }

        @Override
        public List<URL> findResources(String name) {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            ListFactory<URL> resourcesListFactory = ListFactory.start();
            try {
                Enumeration<URL> enumeration = this.loader.getResources(name);
                while (enumeration.hasMoreElements()) {
                    URL resource = enumeration.nextElement();
                    if (resource == null) continue;
                    resourcesListFactory.add(resource);
                }
            }
            catch (IOException e) {
                LoggingService.log(e);
            }
            return resourcesListFactory.result();
        }
    }
}

