/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.diagram.def.DiagramPaletteCompartmentConstants;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramEditorPageDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramNodeDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramPaletteCompartmentDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.gef.ConnectionCreationFactory;
import org.eclipse.sapphire.ui.swt.gef.DiagramPaletteDrawer;
import org.eclipse.sapphire.ui.swt.gef.NodeCreationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphirePaletteRoot
extends PaletteRoot {
    private SapphireDiagramEditorPagePart diagramPart;

    public SapphirePaletteRoot(SapphireDiagramEditorPagePart diagramPart) {
        this.diagramPart = diagramPart;
        this.updatePaletteEntries();
    }

    public void updatePaletteEntries() {
        List<ConnectionCreationToolEntry> list;
        DiagramPaletteDrawer drawer;
        ConnectionCreationToolEntry tool;
        String tpDesc;
        String tpLabel;
        Object factory;
        ImageDescriptor imageDescriptor;
        ImageData imageData;
        this.setDefaultEntry(null);
        ArrayList allEntries = new ArrayList(this.getChildren());
        for (PaletteEntry entry : allEntries) {
            this.remove(entry);
        }
        IDiagramEditorPageDef diagramPageDef = (IDiagramEditorPageDef)this.diagramPart.definition();
        this.add((PaletteEntry)this.createModelIndependentTools());
        List nodeTemplates = this.diagramPart.getVisibleNodeTemplates();
        if (nodeTemplates.isEmpty()) {
            return;
        }
        ArrayList<DiagramPaletteDrawer> drawers = new ArrayList<DiagramPaletteDrawer>();
        HashMap entries = new HashMap();
        ModelElementList compartmentDefs = diagramPageDef.getPaletteCompartments();
        DiagramPaletteDrawer defaultContainer = null;
        if (compartmentDefs.size() == 0) {
            String label = LabelTransformer.transform((String)DiagramPaletteCompartmentConstants.CONNECTIONS_COMPARTMENT_LABEL, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            DiagramPaletteDrawer connectionDrawer = new DiagramPaletteDrawer(label, "Sapphire.Diagram.Palette.Connections");
            drawers.add(connectionDrawer);
            String label2 = LabelTransformer.transform((String)DiagramPaletteCompartmentConstants.NODES_COMPARTMENT_LABEL, (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
            DiagramPaletteDrawer nodesDrawer = new DiagramPaletteDrawer(label2, "Sapphire.Diagram.Palette.Nodes");
            drawers.add(nodesDrawer);
            defaultContainer = connectionDrawer;
        } else {
            for (IDiagramPaletteCompartmentDef compartmentDef : compartmentDefs) {
                String label = LabelTransformer.transform((String)((String)compartmentDef.getLabel().getContent()), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)true);
                DiagramPaletteDrawer drawer2 = new DiagramPaletteDrawer(label, (String)compartmentDef.getId().getContent());
                drawers.add(drawer2);
                if (defaultContainer != null) continue;
                defaultContainer = drawer2;
            }
        }
        for (SapphireDiagramEditorPagePart.ConnectionPalette connectionPalette : this.diagramPart.getConnectionPalettes()) {
            IDiagramConnectionDef connDef = connectionPalette.getConnectionDef();
            imageData = connectionPalette.getImageData();
            imageDescriptor = SwtRendererUtil.toImageDescriptor((ImageData)imageData);
            factory = new ConnectionCreationFactory(connDef);
            tpLabel = (String)connDef.getToolPaletteLabel().getContent();
            if (tpLabel != null) {
                tpLabel = IDiagramConnectionDef.PROP_TOOL_PALETTE_LABEL.getLocalizationService().text(tpLabel, CapitalizationType.TITLE_STYLE, false);
            }
            if ((tpDesc = (String)connDef.getToolPaletteDescription().getContent()) != null) {
                tpDesc = IDiagramConnectionDef.PROP_TOOL_PALETTE_DESCRIPTION.getLocalizationService().text(tpDesc, CapitalizationType.TITLE_STYLE, false);
            }
            if (tpLabel == null) continue;
            tool = new ConnectionCreationToolEntry(tpLabel, tpDesc, (CreationFactory)factory, imageDescriptor, imageDescriptor);
            drawer = this.getDiagramPaletteDrawer(drawers, (String)connDef.getToolPaletteCompartment().getContent());
            list = (ArrayList<ConnectionCreationToolEntry>)entries.get(drawer.getId());
            if (list == null) {
                list = new ArrayList<ConnectionCreationToolEntry>();
                entries.put(drawer.getId(), list);
            }
            list.add(tool);
        }
        for (DiagramNodeTemplate nodeTemplate : nodeTemplates) {
            IDiagramNodeDef nodeDef = nodeTemplate.definition();
            imageData = nodeTemplate.getToolPaletteImage();
            imageDescriptor = SwtRendererUtil.toImageDescriptor((ImageData)imageData);
            factory = new NodeCreationFactory(nodeTemplate);
            tpLabel = (String)nodeDef.getToolPaletteLabel().getContent();
            if (tpLabel != null) {
                tpLabel = IDiagramNodeDef.PROP_TOOL_PALETTE_LABEL.getLocalizationService().text(tpLabel, CapitalizationType.TITLE_STYLE, false);
            }
            if ((tpDesc = (String)nodeDef.getToolPaletteDescription().getContent()) != null) {
                tpDesc = IDiagramNodeDef.PROP_TOOL_PALETTE_DESCRIPTION.getLocalizationService().text(tpDesc, CapitalizationType.TITLE_STYLE, false);
            }
            tool = new CombinedTemplateCreationEntry(tpLabel, tpDesc, (CreationFactory)factory, imageDescriptor, imageDescriptor);
            tool.setToolClass(CreationTool.class);
            drawer = this.getDiagramPaletteDrawer(drawers, (String)nodeDef.getToolPaletteCompartment().getContent());
            list = (List)entries.get(drawer.getId());
            if (list == null) {
                list = new ArrayList();
                entries.put(drawer.getId(), list);
            }
            list.add(tool);
        }
        for (DiagramPaletteDrawer drawer3 : drawers) {
            List list2 = (List)entries.get(drawer3.getId());
            if (list2 != null) {
                Collections.sort(list2, new Comparator<ToolEntry>(){

                    @Override
                    public int compare(ToolEntry x, ToolEntry y) {
                        return x.getLabel().compareTo(y.getLabel());
                    }
                });
                drawer3.addAll(list2);
            }
            this.add((PaletteEntry)drawer3);
        }
    }

    private DiagramPaletteDrawer getDiagramPaletteDrawer(List<DiagramPaletteDrawer> drawers, String id) {
        for (DiagramPaletteDrawer drawer : drawers) {
            if (!id.equals(drawer.getId())) continue;
            return drawer;
        }
        return drawers.get(0);
    }

    private PaletteContainer createModelIndependentTools() {
        PaletteGroup group = new PaletteGroup("Tools");
        PanningSelectionToolEntry tool = new PanningSelectionToolEntry();
        group.add((PaletteEntry)tool);
        this.setDefaultEntry((ToolEntry)tool);
        group.add((PaletteEntry)new MarqueeToolEntry());
        return group;
    }
}

