/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.PreferDefaultValue;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.util.internal.SapphireCommonUtil;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PreferDefaultValueFactsService
extends FactsService {
    @Override
    protected void facts(SortedSet<String> facts) {
        ValueProperty property;
        IModelElement element = this.context(IModelElement.class);
        String defaultValue = SapphireCommonUtil.getDefaultValueLabel(element, property = this.context(ValueProperty.class));
        if (defaultValue != null) {
            facts.add(NLS.bind(Resources.fact, defaultValue));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null) {
                return property.hasAnnotation(PreferDefaultValue.class);
            }
            return false;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new PreferDefaultValueFactsService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String fact;

        static {
            Resources.initializeMessages(PreferDefaultValueFactsService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

