/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValueSerializationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumPossibleValuesService
extends PossibleValuesService {
    private final List<String> values = new ArrayList<String>();

    @Override
    protected void init() {
        super.init();
        ValueProperty property = this.context(ValueProperty.class);
        EnumValueType enumType = new EnumValueType(property.getTypeClass());
        ValueSerializationService valueSerializationService = property.service(ValueSerializationService.class);
        Enum<?>[] enumArray = enumType.getItems();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> item = enumArray[n2];
            this.values.add(valueSerializationService.encode(item));
            ++n2;
        }
    }

    @Override
    protected void fillPossibleValues(SortedSet<String> values) {
        values.addAll(this.values);
    }

    @Override
    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return Status.Severity.OK;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && Enum.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new EnumPossibleValuesService();
        }
    }
}

