/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

public final class StandardElementValidationService
extends ValidationService {
    protected void init() {
        IModelElement element = this.context(IModelElement.class);
        element.attach(new FilteredListener<PropertyEvent>(){

            @Override
            protected void handleTypedEvent(PropertyEvent event) {
                if (event instanceof PropertyValidationEvent || event instanceof PropertyEnablementEvent) {
                    StandardElementValidationService.this.broadcast();
                }
            }
        });
    }

    public Status validate() {
        IModelElement element = this.context(IModelElement.class);
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (ModelProperty property : element.properties()) {
            if (!element.enabled(property)) continue;
            factory.merge(element.validation(property));
        }
        return factory.create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            return true;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new StandardElementValidationService();
        }
    }
}

