/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.List;
import java.util.SortedSet;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticPossibleValuesService
extends PossibleValuesService {
    private final List<String> values;

    public StaticPossibleValuesService(String[] values, String invalidValueMessageTemplate, Status.Severity invalidValueSeverity, boolean caseSensitive) {
        super(invalidValueMessageTemplate, invalidValueSeverity, caseSensitive);
        this.values = ListFactory.unmodifiable(values);
    }

    @Override
    protected void fillPossibleValues(SortedSet<String> values) {
        values.addAll(this.values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(PossibleValues.class) && property.getAnnotation(PossibleValues.class).values().length > 0;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            PossibleValues a = context.find(ValueProperty.class).getAnnotation(PossibleValues.class);
            return new StaticPossibleValuesService(a.values(), a.invalidValueMessage(), a.invalidValueSeverity(), a.caseSensitive());
        }
    }
}

