/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.FormComponentPart;
import org.eclipse.sapphire.ui.FormPart;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.FormDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PageBookDef;
import org.eclipse.sapphire.ui.def.PageBookKeyMapping;
import org.eclipse.sapphire.ui.swt.renderer.GridLayoutUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class PageBookPart
extends FormComponentPart {
    private static FormDef systemDefaultPageDef;
    private Map<Object, FormDef> pageDefs;
    private FormDef defaultPageDef;
    private FormPart currentPage;
    private boolean exposePageValidationState = false;
    private Listener childPartListener = null;

    protected void init() {
        super.init();
        PageBookDef def = (PageBookDef)this.definition;
        this.pageDefs = new LinkedHashMap<Object, FormDef>();
        for (PageBookKeyMapping page : def.getPages()) {
            Object key = this.parsePageKey(page.getKey().getText());
            this.pageDefs.put(key, page);
        }
        this.defaultPageDef = def.getDefaultPage();
        if (this.defaultPageDef.getContent().isEmpty()) {
            this.defaultPageDef = this.initDefaultPageDef();
        }
    }

    protected FormDef initDefaultPageDef() {
        if (systemDefaultPageDef == null) {
            ISapphireUiDef root = (ISapphireUiDef)ISapphireUiDef.TYPE.instantiate();
            systemDefaultPageDef = (FormDef)root.getPartDefs().insert(FormDef.TYPE);
        }
        return systemDefaultPageDef;
    }

    protected Function initVisibleWhenFunction() {
        Function function = new Function(){

            public String name() {
                return "VisibleIfChildrenVisible";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){

                    protected void init() {
                        FilteredListener<PartVisibilityEvent> pageVisibilityListener = new FilteredListener<PartVisibilityEvent>(){

                            protected void handleTypedEvent(PartVisibilityEvent event) {
                                this.refresh();
                            }
                        };
                        PageBookPart.this.attach((Listener)new FilteredListener<PageChangedEvent>((Listener)pageVisibilityListener){
                            private final /* synthetic */ Listener val$pageVisibilityListener;
                            {
                                this.val$pageVisibilityListener = listener;
                            }

                            protected void handleTypedEvent(PageChangedEvent event) {
                                FormPart page = PageBookPart.this.getCurrentPage();
                                if (page != null) {
                                    page.attach(this.val$pageVisibilityListener);
                                }
                                this.refresh();
                            }
                        });
                        FormPart page = PageBookPart.this.getCurrentPage();
                        if (page != null) {
                            page.attach((Listener)pageVisibilityListener);
                        }
                    }

                    protected Object evaluate() {
                        boolean visible = false;
                        FormPart page = PageBookPart.this.getCurrentPage();
                        if (page != null) {
                            visible = page.visible();
                        }
                        return visible;
                    }
                };
            }
        };
        function.init(new Function[0]);
        Function base = super.initVisibleWhenFunction();
        if (base == null) {
            return function;
        }
        return AndFunction.create((Function[])new Function[]{base, function});
    }

    public void render(final SapphireRenderingContext context) {
        final Composite composite = new Composite(context.getComposite(), 0);
        composite.setLayoutData((Object)GridLayoutUtil.gdhspan(this.getScaleVertically() ? GridLayoutUtil.gdfill() : GridLayoutUtil.gdhfill(), 2));
        composite.setLayout((Layout)GridLayoutUtil.glayout(2, 0, 0));
        context.adapt((Control)composite);
        final Listener pageChangeListener = new Listener(){

            public void handle(Event event) {
                if (event instanceof PageChangedEvent) {
                    Control[] controlArray = composite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        control.dispose();
                        ++n2;
                    }
                    if (PageBookPart.this.currentPage != null) {
                        PageBookPart.this.currentPage.render(new SapphireRenderingContext(PageBookPart.this, context, composite));
                    }
                    context.layout();
                }
            }
        };
        this.attach(pageChangeListener);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                PageBookPart.this.detach(pageChangeListener);
            }
        });
        if (this.currentPage != null) {
            this.currentPage.render(new SapphireRenderingContext(this, context, composite));
        }
    }

    public final FormPart getCurrentPage() {
        return this.currentPage;
    }

    protected final void changePage(IModelElement modelElementForPage, Object pageKey) {
        FormDef pageDef = this.defaultPageDef;
        if (pageKey != null) {
            for (Map.Entry<Object, FormDef> entry : this.pageDefs.entrySet()) {
                if (!entry.getKey().equals(pageKey)) continue;
                pageDef = entry.getValue();
                break;
            }
        }
        this.changePage(modelElementForPage, pageDef);
    }

    private void changePage(IModelElement modelElementForPage, FormDef pageDef) {
        if (modelElementForPage == null) {
            throw new IllegalArgumentException();
        }
        FormPart pageToDispose = this.currentPage;
        this.currentPage = null;
        if (pageDef != null) {
            this.currentPage = this.createPagePart(modelElementForPage, pageDef);
            if (this.childPartListener != null) {
                this.currentPage.attach(this.childPartListener);
            }
        }
        if (pageToDispose != null) {
            pageToDispose.dispose();
        }
        this.refreshValidation();
        this.broadcast(new PageChangedEvent(this));
    }

    protected abstract Object parsePageKey(String var1);

    protected FormPart createPagePart(IModelElement modelElementForPage, FormDef pageDef) {
        return (FormPart)PageBookPart.create(this, modelElementForPage, pageDef, this.params);
    }

    protected Status computeValidation() {
        FormPart currentPage;
        if (this.exposePageValidationState && (currentPage = this.getCurrentPage()) != null) {
            return currentPage.validation();
        }
        return Status.createOkStatus();
    }

    protected final void setExposePageValidationState(boolean exposePageValidationState) {
        if (this.exposePageValidationState != exposePageValidationState) {
            this.exposePageValidationState = exposePageValidationState;
            if (this.exposePageValidationState) {
                this.childPartListener = new FilteredListener<PartValidationEvent>(){

                    protected void handleTypedEvent(PartValidationEvent event) {
                        PageBookPart.this.refreshValidation();
                    }
                };
                if (this.currentPage != null) {
                    this.currentPage.attach(this.childPartListener);
                }
            } else {
                this.childPartListener = null;
            }
            this.refreshValidation();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ClassBasedKey {
        private final Class<?> cl;

        private ClassBasedKey(Class<?> cl) {
            this.cl = cl;
        }

        public static ClassBasedKey create(Class<?> cl) {
            return cl == null ? null : new ClassBasedKey(cl);
        }

        public static ClassBasedKey create(Object obj) {
            return obj == null ? null : new ClassBasedKey(obj.getClass());
        }

        public int hashCode() {
            return this.cl == null ? -1 : this.cl.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClassBasedKey)) {
                return false;
            }
            Class<?> cl2 = ((ClassBasedKey)obj).cl;
            return this.cl.isAssignableFrom(cl2) || cl2.isAssignableFrom(this.cl);
        }
    }

    public static final class PageChangedEvent
    extends SapphirePart.PartEvent {
        public PageChangedEvent(SapphirePart part) {
            super(part);
        }
    }
}

