/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramImplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IModelElementTypeDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionTemplate;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.ModelUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramImplicitConnectionTemplate
extends DiagramConnectionTemplate {
    private IDiagramImplicitConnectionBindingDef bindingDef;
    private IDiagramConnectionDef connectionDef;
    protected IModelElement modelElement;
    private SapphireDiagramEditorPagePart diagramEditor;
    private String propertyName;
    private ModelPath allDescendentsPath;
    private ListProperty modelProperty;
    private List<Class<?>> modelElementTypes;
    private List<DiagramImplicitConnectionPart> implicitConnections;
    private Listener modelPropertyListener;
    private Set<DiagramImplicitConnectionTemplateListener> templateListeners;
    private Map<IModelElement, FunctionResult> listEntryFunctionMap;
    private DiagramNodeTemplate nodeTemplate;
    private NodeTemplateListener nodeTemplateListener;

    public DiagramImplicitConnectionTemplate(IDiagramImplicitConnectionBindingDef bindingDef) {
        this.bindingDef = bindingDef;
    }

    @Override
    public void init() {
        this.diagramEditor = (SapphireDiagramEditorPagePart)this.getParentPart();
        this.listEntryFunctionMap = new IdentityHashMap<IModelElement, FunctionResult>();
        this.modelElement = this.getModelElement();
        this.connectionDef = (IDiagramConnectionDef)super.definition();
        this.propertyName = (String)this.bindingDef.getProperty().getContent();
        this.modelProperty = (ListProperty)ModelUtil.resolve(this.modelElement, this.propertyName);
        this.modelElementTypes = new ArrayList();
        ModelElementList<IModelElementTypeDef> types = this.bindingDef.getModelElementTypes();
        for (IModelElementTypeDef typeDef : types) {
            this.modelElementTypes.add(((JavaType)typeDef.getType().resolve()).artifact());
        }
        this.initImplicitConnectionParts();
        this.templateListeners = new CopyOnWriteArraySet<DiagramImplicitConnectionTemplateListener>();
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramImplicitConnectionTemplate.this.refreshImplicitConnections();
            }
        };
        this.addModelListener();
        this.nodeTemplate = this.diagramEditor.getNodeTemplate((ModelProperty)this.modelProperty);
        if (this.nodeTemplate != null) {
            this.nodeTemplateListener = new NodeTemplateListener();
            this.nodeTemplate.addTemplateListener(this.nodeTemplateListener);
        }
    }

    public SapphireDiagramEditorPagePart getDiagramEditorPart() {
        return this.diagramEditor;
    }

    @Override
    public void addModelListener() {
        this.modelElement.attach(this.modelPropertyListener, this.propertyName);
        String temp = String.valueOf(this.propertyName) + "/*";
        this.allDescendentsPath = new ModelPath(temp);
        this.modelElement.attach(this.modelPropertyListener, this.allDescendentsPath);
    }

    @Override
    public void removeModelListener() {
        this.modelElement.detach(this.modelPropertyListener, this.propertyName);
        this.modelElement.detach(this.modelPropertyListener, this.allDescendentsPath);
    }

    public void refreshImplicitConnections() {
        this.removeModelListener();
        List<IModelElement> newFilteredList = this.getFilteredModelElementList();
        for (DiagramImplicitConnectionPart connPart : this.implicitConnections) {
            this.notifyConnectionDelete(connPart);
            connPart.dispose();
        }
        this.implicitConnections.clear();
        int i = 0;
        while (i < newFilteredList.size() - 1) {
            DiagramImplicitConnectionPart connPart = this.createNewImplicitConnectionPart(newFilteredList.get(i), newFilteredList.get(i + 1));
            if (connPart.getEndpoint1() != null && connPart.getEndpoint2() != null && this.diagramEditor.getDiagramNodePart(connPart.getEndpoint1()) != null && this.diagramEditor.getDiagramNodePart(connPart.getEndpoint2()) != null) {
                this.implicitConnections.add(connPart);
                this.notifyConnectionAdd(connPart);
            }
            ++i;
        }
        this.addModelListener();
    }

    public List<DiagramImplicitConnectionPart> getImplicitConnections() {
        return this.implicitConnections;
    }

    private void initImplicitConnectionParts() {
        List<IModelElement> newFilteredList = this.getFilteredModelElementList();
        this.implicitConnections = new ArrayList<DiagramImplicitConnectionPart>();
        int i = 0;
        while (i < newFilteredList.size() - 1) {
            DiagramImplicitConnectionPart connPart = this.createNewImplicitConnectionPart(newFilteredList.get(i), newFilteredList.get(i + 1));
            this.implicitConnections.add(connPart);
            ++i;
        }
    }

    private List<IModelElement> getFilteredModelElementList() {
        ModelElementList list = this.modelElement.read(this.modelProperty);
        ArrayList<IModelElement> filteredList = new ArrayList<IModelElement>();
        for (IModelElement listEntryModelElement : list) {
            if (!this.isRightEntry(listEntryModelElement)) continue;
            filteredList.add(listEntryModelElement);
        }
        return filteredList;
    }

    private DiagramImplicitConnectionPart createNewImplicitConnectionPart(IModelElement srcNodeModel, IModelElement targetNodeModel) {
        DiagramImplicitConnectionPart connPart = new DiagramImplicitConnectionPart(srcNodeModel, targetNodeModel);
        connPart.init(this, srcNodeModel, this.connectionDef, Collections.<String, String>emptyMap());
        return connPart;
    }

    private boolean isRightEntry(IModelElement entryModelElement) {
        boolean isRightType = true;
        if (this.modelElementTypes.size() > 0) {
            isRightType = false;
            for (Class<?> eleType : this.modelElementTypes) {
                if (!eleType.isAssignableFrom(entryModelElement.getClass())) continue;
                isRightType = true;
                break;
            }
        }
        if (isRightType && this.bindingDef.getCondition() != null) {
            isRightType = false;
            FunctionResult fr = this.listEntryFunctionMap.get(entryModelElement);
            if (fr == null) {
                fr = this.initExpression(entryModelElement, (Function)this.bindingDef.getCondition().getContent(), String.class, null, new Runnable(){

                    public void run() {
                        DiagramImplicitConnectionTemplate.this.refreshImplicitConnections();
                    }
                });
                this.listEntryFunctionMap.put(entryModelElement, fr);
            }
            if (fr != null && ((String)fr.value()).equals("true")) {
                isRightType = true;
            }
        }
        return isRightType;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        throw new UnsupportedOperationException();
    }

    public void addTemplateListener(DiagramImplicitConnectionTemplateListener listener) {
        this.templateListeners.add(listener);
    }

    public void removeTemplateListener(DiagramImplicitConnectionTemplateListener listener) {
        this.templateListeners.remove(listener);
    }

    public void notifyConnectionAdd(DiagramImplicitConnectionPart connPart) {
        for (DiagramImplicitConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionAdd(new DiagramConnectionEvent(connPart));
        }
    }

    public void notifyConnectionDelete(DiagramImplicitConnectionPart connPart) {
        for (DiagramImplicitConnectionTemplateListener listener : this.templateListeners) {
            listener.handleConnectionDelete(new DiagramConnectionEvent(connPart));
        }
    }

    @Override
    public void dispose() {
        for (FunctionResult fr : this.listEntryFunctionMap.values()) {
            if (fr == null) continue;
            fr.dispose();
        }
        List<DiagramImplicitConnectionPart> connParts = this.getImplicitConnections();
        for (DiagramImplicitConnectionPart connPart : connParts) {
            connPart.dispose();
        }
    }

    public static abstract class DiagramImplicitConnectionTemplateListener {
        public void handleConnectionAdd(DiagramConnectionEvent event) {
        }

        public void handleConnectionDelete(DiagramConnectionEvent event) {
        }
    }

    private class NodeTemplateListener
    extends DiagramNodeTemplate.DiagramNodeTemplateListener {
        private NodeTemplateListener() {
        }

        public void handleNodeAdd(DiagramNodePart nodePart) {
            DiagramImplicitConnectionTemplate.this.refreshImplicitConnections();
        }
    }
}

