/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.samples.catalog;

import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.BindingImpl;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.ChildXmlResource;
import org.eclipse.sapphire.modeling.xml.StandardXmlListBindingImpl;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlUtil;
import org.eclipse.sapphire.samples.catalog.Catalog;
import org.eclipse.sapphire.samples.catalog.Item;
import org.eclipse.sapphire.samples.catalog.Manufacturer;
import org.eclipse.sapphire.util.IdentityHashSet;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ManufacturersBinding
extends ListBindingImpl {
    private List<ManufacturerResource> cache = ListFactory.empty();
    private Listener listener;

    public void init(final IModelElement element, final ModelProperty property, String[] params) {
        super.init(element, property, params);
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                element.refresh(property);
                for (Manufacturer manufacturer : ((Catalog)element).getManufacturers()) {
                    manufacturer.refresh((ModelProperty)Manufacturer.PROP_ITEMS);
                }
            }
        };
        element.attach(this.listener, "Items/Manufacturer");
    }

    public List<? extends Resource> read() {
        List resources;
        TreeSet<String> manufacturers = new TreeSet<String>(ManufacturerNamesComparator.INSTANCE);
        for (Item item : ((Catalog)this.element()).getItems()) {
            manufacturers.add(item.getManufacturer().getText());
        }
        ListFactory resourcesListFactory = ListFactory.start();
        IdentityHashSet reused = new IdentityHashSet();
        for (String manufacturer : manufacturers) {
            boolean found = false;
            for (ManufacturerResource resource : this.cache) {
                if (ManufacturerNamesComparator.INSTANCE.compare(manufacturer, resource.getName()) != 0) continue;
                resourcesListFactory.add((Object)resource);
                reused.add(resource);
                found = true;
                break;
            }
            if (found) continue;
            resourcesListFactory.add((Object)new ManufacturerResource(manufacturer));
        }
        for (ManufacturerResource resource : this.cache) {
            if (reused.contains((Object)resource)) continue;
            resource.dispose();
        }
        this.cache = resources = resourcesListFactory.result();
        this.cache = resources;
        return this.cache;
    }

    public ModelElementType type(Resource resource) {
        return Manufacturer.TYPE;
    }

    public void dispose() {
        for (ManufacturerResource resource : this.cache) {
            resource.dispose();
        }
        this.cache = null;
        this.element().detach(this.listener, "Items/Manufacturer");
        this.listener = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ManufacturerNamesComparator
    implements Comparator<String> {
        public static ManufacturerNamesComparator INSTANCE = new ManufacturerNamesComparator();

        private ManufacturerNamesComparator() {
        }

        @Override
        public int compare(String x, String y) {
            x = x == null ? "" : x.trim();
            String string = y = y == null ? "" : y.trim();
            if (x == y) {
                return 0;
            }
            if (x.length() == 0) {
                return Integer.MAX_VALUE;
            }
            if (y.length() == 0) {
                return Integer.MIN_VALUE;
            }
            return x.compareToIgnoreCase(y);
        }
    }

    private final class ManufacturerResource
    extends XmlResource {
        private String name;

        public ManufacturerResource(String name) {
            super((XmlResource)ManufacturersBinding.this.element().resource());
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
            for (Item item : ((Manufacturer)this.element()).getItems()) {
                item.setManufacturer(name);
            }
        }

        protected BindingImpl createBinding(ModelProperty property) {
            Object binding = null;
            if (property == Manufacturer.PROP_NAME) {
                binding = new ValueBindingImpl(){

                    public String read() {
                        return ManufacturerResource.this.getName();
                    }

                    public void write(String value) {
                        ManufacturerResource.this.setName(value);
                    }
                };
            } else if (property == Manufacturer.PROP_ITEMS) {
                binding = new StandardXmlListBindingImpl(){

                    protected void initBindingMetadata(IModelElement element, ModelProperty property, String[] params) {
                        this.xmlElementNames = new QName[]{XmlUtil.createQualifiedName((String)"Item", null)};
                        this.modelElementTypes = new ModelElementType[]{Item.TYPE};
                    }

                    protected List<?> readUnderlyingList() {
                        List all = super.readUnderlyingList();
                        ListFactory filtered = ListFactory.start();
                        for (Object obj : all) {
                            XmlElement element = (XmlElement)obj;
                            String manufacturer = element.getChildNodeText("Manufacturer");
                            if (ManufacturerNamesComparator.INSTANCE.compare(ManufacturerResource.this.name, manufacturer) != 0) continue;
                            filtered.add((Object)element);
                        }
                        return filtered.result();
                    }

                    protected Object insertUnderlyingObject(ModelElementType type, int position) {
                        XmlElement element = (XmlElement)super.insertUnderlyingObject(type, position);
                        element.setChildNodeText("Manufacturer", ManufacturerResource.this.name, true);
                        return element;
                    }

                    protected Resource resource(Object obj) {
                        return new ChildXmlResource((XmlResource)ManufacturerResource.this, (XmlElement)obj);
                    }

                    protected XmlElement getXmlElement(boolean createIfNecessary) {
                        return ((XmlResource)((Catalog)this.element().nearest(Catalog.class)).adapt(XmlResource.class)).getXmlElement(createIfNecessary);
                    }
                };
            }
            if (binding != null) {
                binding.init(this.element(), property, null);
            }
            return binding;
        }

        public XmlElement getXmlElement(boolean createIfNecessary) {
            return null;
        }
    }
}

