/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.util.SortedSetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Status {
    public static final String TYPE_MISC_OK = "Sapphire.Miscellaneous.Ok";
    public static final String TYPE_MISC_PROBLEM = "Sapphire.Miscellaneous.Problem";
    private static final Status OK_STATUS = new Status(Severity.OK, "Sapphire.Miscellaneous.Ok", Resources.defaultOkMessage, null, SortedSetFactory.<Status>empty());
    private final Severity severity;
    private final String type;
    private final String message;
    private final Throwable exception;
    private final SortedSet<Status> children;

    public static Status createOkStatus() {
        return OK_STATUS;
    }

    public static Status createWarningStatus(String message) {
        return Status.createStatus(Severity.WARNING, message);
    }

    public static Status createErrorStatus(String message) {
        return Status.createErrorStatus(message, null);
    }

    public static Status createErrorStatus(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = Resources.defaultErrorMessage;
        }
        return Status.createErrorStatus(message, exception);
    }

    public static Status createErrorStatus(String message, Throwable exception) {
        return Status.createStatus(Severity.ERROR, message, exception);
    }

    public static Status createStatus(Severity severity, String message, Throwable exception) {
        return Status.factoryForLeaf().severity(severity).message(message).exception(exception).create();
    }

    public static Status createStatus(Severity severity, String message) {
        return Status.createStatus(severity, message, null);
    }

    public static LeafStatusFactory factoryForLeaf() {
        return new LeafStatusFactory();
    }

    public static CompositeStatusFactory factoryForComposite() {
        return new CompositeStatusFactory();
    }

    private Status(Severity severity, String type, String message, Throwable exception, SortedSet<Status> children) {
        this.severity = severity;
        this.type = type == null ? (severity == Severity.OK ? TYPE_MISC_OK : TYPE_MISC_PROBLEM) : type;
        this.message = message;
        this.exception = exception;
        this.children = children;
    }

    public boolean ok() {
        return this.severity == Severity.OK;
    }

    public Severity severity() {
        return this.severity;
    }

    public String type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public Throwable exception() {
        return this.exception;
    }

    public SortedSet<Status> children() {
        return this.children;
    }

    public boolean contains(String type) {
        if (MiscUtil.equal(this.type, type)) {
            return true;
        }
        for (Status child : this.children) {
            if (!child.contains(type)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        Status st;
        if (obj == this) {
            return true;
        }
        if (obj instanceof Status && (st = (Status)obj).severity() == this.severity() && st.children().size() == this.children().size() && st.exception() == this.exception() && st.message().equals(this.message())) {
            Iterator itr1 = st.children().iterator();
            Iterator itr2 = this.children().iterator();
            while (itr1.hasNext()) {
                if (((Status)itr1.next()).equals(itr2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.severity().code() ^ this.message().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.severity().name());
        buf.append(" : ");
        buf.append(this.message());
        Throwable e = this.exception();
        if (e != null) {
            buf.append(System.getProperty("line.separator"));
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            buf.append(sw.toString());
        }
        return buf.toString();
    }

    /* synthetic */ Status(Severity severity, String string, String string2, Throwable throwable, SortedSet sortedSet, Status status) {
        this(severity, string, string2, throwable, sortedSet);
    }

    public static final class CompositeStatusFactory {
        private final SortedSetFactory<Status> children = SortedSetFactory.start(StatusComparator.access$1());

        private CompositeStatusFactory() {
        }

        public CompositeStatusFactory merge(Status status) {
            if (status != null) {
                SortedSet<Status> children = status.children();
                if (children.isEmpty()) {
                    Severity sev = status.severity();
                    if (sev != Severity.OK) {
                        this.children.add(status);
                    }
                } else {
                    for (Status st : children) {
                        this.merge(st);
                    }
                }
            }
            return this;
        }

        public Status create() {
            int count = this.children.size();
            if (count == 0) {
                return Status.createOkStatus();
            }
            Status first = this.children.first();
            if (count == 1) {
                return first;
            }
            return new Status(first.severity(), Status.TYPE_MISC_PROBLEM, first.message(), first.exception(), this.children.result(), null);
        }
    }

    public static final class LeafStatusFactory {
        private Severity severity;
        private String type;
        private String message;
        private Throwable exception;

        private LeafStatusFactory() {
        }

        public LeafStatusFactory severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public LeafStatusFactory type(String type) {
            this.type = type;
            return this;
        }

        public LeafStatusFactory message(String message) {
            this.message = message;
            return this;
        }

        public LeafStatusFactory exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public Status create() {
            if (this.severity == null) {
                throw new IllegalStateException();
            }
            if (this.message == null) {
                throw new IllegalStateException();
            }
            return new Status(this.severity, this.type, this.message, this.exception, SortedSetFactory.empty(), null);
        }
    }

    private static final class Resources
    extends NLS {
        public static String defaultErrorMessage;
        public static String defaultOkMessage;

        static {
            Resources.initializeMessages(Status.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        OK(0),
        WARNING(1),
        ERROR(2);

        private int code;

        private Severity(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StatusComparator
    implements Comparator<Status> {
        private static final StatusComparator INSTANCE = new StatusComparator();

        private StatusComparator() {
        }

        @Override
        public int compare(Status x, Status y) {
            int result = y.severity.code() - x.severity.code();
            if (result == 0 && (result = x.message.compareTo(y.message)) == 0 && (result = x.type.compareTo(y.type)) == 0) {
                if (x.exception != y.exception) {
                    if (x.exception == null) {
                        result = -1;
                    } else if (y.exception == null) {
                        result = 1;
                    } else {
                        result = x.exception.getClass().getName().compareTo(y.exception.getClass().getName());
                        if (result == 0) {
                            result = System.identityHashCode(x.exception) - System.identityHashCode(y.exception);
                        }
                    }
                }
                if (result == 0 && (result = x.children.size() - y.children.size()) == 0) {
                    Iterator xChildren = x.children.iterator();
                    Iterator yChildren = y.children.iterator();
                    while (xChildren.hasNext() && result == 0) {
                        result = this.compare((Status)xChildren.next(), (Status)yChildren.next());
                    }
                }
            }
            return result;
        }

        static /* synthetic */ StatusComparator access$1() {
            return INSTANCE;
        }
    }
}

