/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.EnumSerialization;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValueSerializationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumSerializationService
extends ValueSerializationService {
    private EnumValueType enumValueType;

    @Override
    protected void init() {
        super.init();
        this.enumValueType = new EnumValueType(this.context(ValueProperty.class).getTypeClass());
    }

    @Override
    protected Enum<?> decodeFromString(String value) {
        Enum<?> result = null;
        Enum<?>[] enumArray = this.enumValueType.getItems();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            String x;
            int n3;
            int n4;
            String[] stringArray;
            Enum<?> enumItem = enumArray[n2];
            EnumSerialization enumSerializationAnnotation = this.enumValueType.getAnnotation(enumItem, EnumSerialization.class);
            if (enumSerializationAnnotation == null) {
                if (enumItem.name().equalsIgnoreCase(value)) {
                    result = enumItem;
                }
            } else if (enumSerializationAnnotation.caseSensitive()) {
                if (enumSerializationAnnotation.primary().equals(value)) {
                    result = enumItem;
                } else {
                    stringArray = enumSerializationAnnotation.alternative();
                    n4 = stringArray.length;
                    n3 = 0;
                    while (n3 < n4) {
                        x = stringArray[n3];
                        if (x.equals(value)) {
                            result = enumItem;
                            break;
                        }
                        ++n3;
                    }
                }
            } else if (enumSerializationAnnotation.primary().equalsIgnoreCase(value)) {
                result = enumItem;
            } else {
                stringArray = enumSerializationAnnotation.alternative();
                n4 = stringArray.length;
                n3 = 0;
                while (n3 < n4) {
                    x = stringArray[n3];
                    if (x.equalsIgnoreCase(value)) {
                        result = enumItem;
                        break;
                    }
                    ++n3;
                }
            }
            if (result != null) break;
            ++n2;
        }
        return result;
    }

    @Override
    public String encode(Object value) {
        String result = null;
        if (value != null) {
            Enum val = (Enum)value;
            EnumSerialization enumStringBindingAnnotation = this.enumValueType.getAnnotation(val, EnumSerialization.class);
            result = enumStringBindingAnnotation == null ? val.name() : enumStringBindingAnnotation.primary();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.isOfType(Enum.class);
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new EnumSerializationService();
        }
    }
}

