/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.util.internal.SapphireCommonUtil;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.InitialValueService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InitialValueFactsService
extends FactsService {
    @Override
    protected void facts(SortedSet<String> facts) {
        ValueProperty property;
        IModelElement element = this.context(IModelElement.class);
        InitialValueService initialValueService = element.service(property = this.context(ValueProperty.class), InitialValueService.class);
        String value = initialValueService.value();
        if (value != null && value.trim().length() > 0) {
            String valueLabel = SapphireCommonUtil.getValueLabel(element, property, value);
            facts.add(NLS.bind(Resources.statement, valueLabel));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            IModelElement element;
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && (element = context.find(IModelElement.class)).service(property, InitialValueService.class) != null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new InitialValueFactsService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String statement;

        static {
            Resources.initializeMessages(InitialValueFactsService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

