/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationAggregationService;
import org.eclipse.sapphire.services.ValidationService;

public final class PropertyValidationAggregationService
extends ValidationAggregationService {
    protected void initDataService() {
        IModelElement element = this.context(IModelElement.class);
        ModelProperty property = this.context(ModelProperty.class);
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                PropertyValidationAggregationService.this.refresh();
            }
        };
        element.attach((Listener)listener, property);
        Listener validationServiceListener = new Listener(){

            public void handle(Event event) {
                PropertyValidationAggregationService.this.refresh();
            }
        };
        for (ValidationService service : element.services(property, ValidationService.class)) {
            service.attach(validationServiceListener);
        }
    }

    protected Status compute() {
        IModelElement element = this.context(IModelElement.class);
        ModelProperty property = this.context(ModelProperty.class);
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (ValidationService service : element.services(property, ValidationService.class)) {
            try {
                factory.merge(service.validate());
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
        return factory.create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            return true;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new PropertyValidationAggregationService();
        }
    }
}

