/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.CorruptedResourceExceptionInterceptor;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.tests.modeling.xml.XmlBindingTestModel;
import org.eclipse.sapphire.tests.modeling.xml.XmlBindingTestModelAltB;
import org.eclipse.sapphire.tests.modeling.xml.XmlBindingTestModelAltC;
import org.eclipse.sapphire.tests.modeling.xml.binding.XmlBindingTestSuite;
import org.eclipse.sapphire.tests.modeling.xml.dtd.XmlDtdTestSuite;
import org.eclipse.sapphire.tests.modeling.xml.xsd.XmlXsdTestSuite;

public final class XmlBindingTests
extends TestCase {
    private XmlBindingTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Xml");
        suite.addTest((Test)new XmlBindingTests("testValueProperties1"));
        suite.addTest((Test)new XmlBindingTests("testValueProperties2"));
        suite.addTest((Test)new XmlBindingTests("testValueProperties3"));
        suite.addTest(XmlBindingTestSuite.suite());
        suite.addTest(XmlDtdTestSuite.suite());
        suite.addTest(XmlXsdTestSuite.suite());
        return suite;
    }

    public void testValueProperties1() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        XmlBindingTestModel model = (XmlBindingTestModel)XmlBindingTestModel.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        this.testValueProperties(resourceStore, model, this.loadResource("testValueProperties1.txt"));
    }

    public void testValueProperties2() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        XmlBindingTestModelAltB model = (XmlBindingTestModelAltB)XmlBindingTestModelAltB.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        this.testValueProperties(resourceStore, model, this.loadResource("testValueProperties2.txt"));
    }

    public void testValueProperties3() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        XmlResourceStore xmlResourceStore = new XmlResourceStore(resourceStore);
        XmlBindingTestModelAltC model = (XmlBindingTestModelAltC)XmlBindingTestModelAltC.TYPE.instantiate((Resource)new RootXmlResource(xmlResourceStore));
        this.testValueProperties(resourceStore, model, this.loadResource("testValueProperties3.txt"));
    }

    private void testValueProperties(ByteArrayResourceStore resourceStore, XmlBindingTestModel model, String expected) throws Exception {
        model.resource().setCorruptedResourceExceptionInterceptor(new CorruptedResourceExceptionInterceptor(){

            public boolean shouldAttemptRepair() {
                return true;
            }
        });
        model.setValuePropertyA("aaaa");
        XmlBindingTests.assertEquals((String)"aaaa", (String)model.getValuePropertyA().getText());
        model.setValuePropertyB("bbbb");
        XmlBindingTests.assertEquals((String)"bbbb", (String)model.getValuePropertyB().getText());
        model.setValuePropertyC("cccc");
        XmlBindingTests.assertEquals((String)"cccc", (String)model.getValuePropertyC().getText());
        model.setValuePropertyD("dddd");
        XmlBindingTests.assertEquals((String)"dddd", (String)model.getValuePropertyD().getText());
        model.setValuePropertyE("eeee");
        XmlBindingTests.assertEquals((String)"eeee", (String)model.getValuePropertyE().getText());
        model.setValuePropertyF("ffff");
        XmlBindingTests.assertEquals((String)"ffff", (String)model.getValuePropertyF().getText());
        model.resource().save();
        String result = new String(resourceStore.getContents(), "UTF-8");
        XmlBindingTests.assertEqualsIgnoreNewLineDiffs(expected, result);
    }

    private InputStream loadResourceAsStream(String name) {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("XmlBindingTests." + name);
        if (in == null) {
            throw new IllegalArgumentException(name);
        }
        return in;
    }

    private String loadResource(String name) throws Exception {
        String string;
        InputStream in = this.loadResourceAsStream(name);
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            char[] chars = new char[1024];
            StringBuilder buf = new StringBuilder();
            int i = r.read(chars);
            while (i != -1) {
                buf.append(chars, 0, i);
                i = r.read(chars);
            }
            string = buf.toString();
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    private static void assertEqualsIgnoreNewLineDiffs(String expected, String actual) {
        XmlBindingTests.assertEquals((String)expected.replace("\r", ""), (String)actual.replace("\r", ""));
    }
}

