/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.xml.editor;

import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.osgi.BundleBasedContext;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.form.editors.masterdetails.MasterDetailsEditorPage;
import org.eclipse.sapphire.ui.swt.xml.editor.XmlEditorResourceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SapphireEditorForXml
extends SapphireEditor
implements IExecutableExtension {
    private ModelElementType type;
    private DefinitionLoader.Reference<EditorPageDef> definition;
    private StructuredTextEditor sourcePage;
    private MasterDetailsEditorPage formPage;

    public SapphireEditorForXml(ModelElementType type, DefinitionLoader.Reference<EditorPageDef> definition) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.definition = definition;
    }

    public SapphireEditorForXml() {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        super.setInitializationData(config, propertyName, data);
        if (this.definition == null) {
            String bundleId = config.getContributor().getName();
            Context context = BundleBasedContext.adapt((String)bundleId);
            Map properties = (Map)data;
            String sdef = (String)properties.get("sdef");
            this.definition = DefinitionLoader.context((Context)context).sdef(sdef).page();
            JavaType elementJavaType = (JavaType)((EditorPageDef)this.definition.resolve()).getElementType().resolve();
            this.type = ModelElementType.read((Class)elementJavaType.artifact(), (boolean)true);
        }
    }

    public final StructuredTextEditor getXmlEditor() {
        return this.sourcePage;
    }

    protected IModelElement createModel() {
        XmlEditorResourceStore store = this.createResourceStore(this.sourcePage);
        return this.type.instantiate((Resource)new RootXmlResource((XmlResourceStore)store));
    }

    protected XmlEditorResourceStore createResourceStore(StructuredTextEditor sourceEditor) {
        return new XmlEditorResourceStore(this, this.sourcePage);
    }

    protected final void createSourcePages() throws PartInitException {
        this.sourcePage = new StructuredTextEditor();
        this.sourcePage.setEditorPart((IEditorPart)this);
        int index = this.addPage((IEditorPart)this.sourcePage, this.getEditorInput());
        this.setPageText(index, Resources.sourcePageTitle);
    }

    protected void createFormPages() throws PartInitException {
        this.formPage = new MasterDetailsEditorPage((SapphireEditor)this, this.getModelElement(), this.definition);
        this.addPage(0, (IFormPage)this.formPage);
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page == this.sourcePage) {
            return (IContentOutlinePage)this.sourcePage.getAdapter(IContentOutlinePage.class);
        }
        return super.getContentOutline(page);
    }

    public void dispose() {
        super.dispose();
        this.type = null;
        this.definition = null;
        this.sourcePage = null;
        this.formPage = null;
    }

    private static final class Resources
    extends NLS {
        public static String sourcePageTitle;

        static {
            Resources.initializeMessages((String)SapphireEditorForXml.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

