/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEvent;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionEndpointBindingDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramExplicitConnectionBindingDef;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.IdUtil;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;

public class DiagramEmbeddedConnectionPart
extends DiagramConnectionPart {
    private IModelElement srcNodeModel;
    private IModelElement endpointModel;
    private Listener endpointModelListener;
    private ModelPath endpointPath;
    private FunctionResult endpointFunctionResult;
    private IDiagramConnectionEndpointBindingDef endpointDef;

    public DiagramEmbeddedConnectionPart(IDiagramExplicitConnectionBindingDef connBindingDef, IModelElement srcNodeModel, ModelPath endpointPath) {
        this.bindingDef = connBindingDef;
        this.srcNodeModel = srcNodeModel;
        this.endpointPath = endpointPath;
    }

    protected void init() {
        this.initLabelId();
        this.endpointModelListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramEmbeddedConnectionPart.this.handlEndpointModelPropertyChange(event);
            }
        };
        this.endpointDef = (IDiagramConnectionEndpointBindingDef)this.bindingDef.getEndpoint2().element();
        this.endpointModel = this.resolveEndpoint(this.modelElement, this.endpointPath);
        if (this.endpointModel != null) {
            this.endpointFunctionResult = this.initExpression(this.endpointModel, (Function)this.endpointDef.getValue().getContent(), String.class, null, new Runnable(){

                public void run() {
                }
            });
        }
        this.modelPropertyListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                DiagramEmbeddedConnectionPart.this.handleModelPropertyChange(event);
            }
        };
        this.addModelListener();
    }

    public IModelElement getEndpoint1() {
        return this.srcNodeModel;
    }

    public IModelElement getEndpoint2() {
        return this.endpointModel;
    }

    protected void handlEndpointModelPropertyChange(PropertyEvent event) {
        IModelElement newTargetModel;
        if ((this.endpointModel == null || event.element() == this.endpointModel) && (newTargetModel = this.resolveEndpoint(this.modelElement, this.endpointPath)) != this.endpointModel) {
            this.handleEndpointChange();
            this.notifyConnectionEndpointUpdate();
        }
    }

    public void resetEndpoint1() {
    }

    public void resetEndpoint2() {
        if (this.endpointFunctionResult != null) {
            SapphireDiagramEditorPagePart diagramPart;
            DiagramNodePart nodePart;
            String value = (String)this.endpointFunctionResult.value();
            if ((value == null || value.length() == 0) && (nodePart = (diagramPart = this.getDiagramConnectionTemplate().getDiagramEditor()).getDiagramNodePart(this.endpointModel)) != null) {
                value = IdUtil.computeNodeId(nodePart);
            }
            String property = (String)this.endpointDef.getProperty().getContent();
            this.setModelProperty(this.modelElement, property, (Object)value);
        }
    }

    public void resetEndpoint1(DiagramNodePart newSrcNode) {
    }

    public DiagramNodePart getSourceNodePart() {
        SapphireDiagramEditorPagePart diagramPart = (SapphireDiagramEditorPagePart)this.getParentPart().getParentPart().getParentPart();
        return diagramPart.getDiagramNodePart(this.srcNodeModel);
    }

    public void dispose() {
        super.dispose();
        if (this.endpointFunctionResult != null) {
            this.endpointFunctionResult.dispose();
        }
    }

    public void addModelListener() {
        if (this.labelProperty != null) {
            this.modelElement.attach(this.modelPropertyListener, this.labelProperty.getName());
        }
        this.modelElement.attach(this.modelPropertyListener, (String)this.endpointDef.getProperty().getContent());
        if (this.endpointModel != null) {
            this.endpointModel.attach(this.endpointModelListener);
        }
    }

    public void removeModelListener() {
        if (this.labelProperty != null) {
            this.modelElement.detach(this.modelPropertyListener, this.labelProperty.getName());
        }
        this.modelElement.detach(this.modelPropertyListener, (String)this.endpointDef.getProperty().getContent());
        if (this.endpointModel != null) {
            this.endpointModel.detach(this.endpointModelListener);
        }
    }

    protected void handleModelPropertyChange(PropertyEvent event) {
        ModelProperty property = event.property();
        if (property.getName().equals(this.endpointDef.getProperty().getContent())) {
            this.handleEndpointChange();
            this.notifyConnectionEndpointUpdate();
        }
    }

    private void handleEndpointChange() {
        this.endpointModel = this.resolveEndpoint(this.modelElement, this.endpointPath);
        if (this.endpointFunctionResult != null) {
            this.endpointFunctionResult.dispose();
            this.endpointFunctionResult = null;
        }
        if (this.endpointModel != null) {
            this.endpointFunctionResult = this.initExpression(this.endpointModel, (Function)this.endpointDef.getValue().getContent(), String.class, null, new Runnable(){

                public void run() {
                }
            });
        }
    }
}

