/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.ui.FormComponentPart;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.PartVisibilityEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.def.FormDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormPart
extends FormComponentPart {
    private List<SapphirePart> childParts;

    @Override
    protected void init() {
        super.init();
        this.childParts = ListFactory.unmodifiable(this.initChildParts());
        FilteredListener<PartValidationEvent> childPartListener = new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                FormPart.this.refreshValidation();
            }
        };
        for (SapphirePart part : this.childParts) {
            part.attach((Listener)childPartListener);
        }
    }

    @Override
    protected Function initVisibleWhenFunction() {
        return AndFunction.create((Function[])new Function[]{super.initVisibleWhenFunction(), new Function(){

            public String name() {
                return "VisibleIfChildrenVisible";
            }

            public FunctionResult evaluate(FunctionContext context) {
                return new FunctionResult(this, context){

                    protected void init() {
                        FilteredListener<PartVisibilityEvent> listener = new FilteredListener<PartVisibilityEvent>(){

                            protected void handleTypedEvent(PartVisibilityEvent event) {
                                this.refresh();
                            }
                        };
                        for (SapphirePart sapphirePart : FormPart.this.getChildParts()) {
                            sapphirePart.attach((Listener)listener);
                        }
                    }

                    protected Object evaluate() {
                        boolean visible = false;
                        for (SapphirePart sapphirePart : FormPart.this.getChildParts()) {
                            if (!sapphirePart.visible()) continue;
                            visible = true;
                            break;
                        }
                        return visible;
                    }
                };
            }
        }});
    }

    protected List<SapphirePart> initChildParts() {
        IModelElement element = this.getLocalModelElement();
        FormDef def = (FormDef)this.definition;
        ListFactory partsListFactory = ListFactory.start();
        for (PartDef childPartDef : def.getContent()) {
            partsListFactory.add((Object)FormPart.create(this, element, childPartDef, this.params));
        }
        return partsListFactory.result();
    }

    public List<? extends SapphirePart> getChildParts() {
        return this.childParts;
    }

    @Override
    public void render(SapphireRenderingContext context) {
        if (!this.visible()) {
            return;
        }
        for (SapphirePart sapphirePart : this.getChildParts()) {
            sapphirePart.render(context);
        }
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (SapphirePart sapphirePart : this.getChildParts()) {
            factory.merge(sapphirePart.validation());
        }
        return factory.create();
    }

    @Override
    public boolean setFocus() {
        for (SapphirePart sapphirePart : this.getChildParts()) {
            if (!sapphirePart.setFocus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(ModelPath path) {
        for (SapphirePart sapphirePart : this.getChildParts()) {
            if (!sapphirePart.setFocus(path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        for (SapphirePart sapphirePart : this.getChildParts()) {
            sapphirePart.dispose();
        }
        super.dispose();
    }
}

