/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementsTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "Sapphire.ModelElements";
    private static final int TYPE_ID = ModelElementsTransfer.registerType((String)"Sapphire.ModelElements");
    private final ClassLoader classLoader;

    public ModelElementsTransfer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        List elements = (List)data;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(byteArrayOutputStream);
            this.javaToNative(elements, out);
            out.close();
            byteArrayOutputStream.close();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {}
    }

    private void javaToNative(List<IModelElement> elements, DataOutputStream out) throws IOException {
        out.writeInt(elements.size());
        for (IModelElement element : elements) {
            this.javaToNative(element, out);
        }
    }

    private void javaToNative(IModelElement element, DataOutputStream out) throws IOException {
        out.writeUTF(element.type().getQualifiedName());
        for (ModelProperty property : element.properties()) {
            ModelElementList list;
            if (property.isReadOnly()) continue;
            if (property instanceof ValueProperty) {
                String value = element.read((ValueProperty)property).getText(false);
                if (value == null) continue;
                out.writeByte(1);
                out.writeUTF(property.getName());
                out.writeUTF(value);
                continue;
            }
            if (property instanceof ElementProperty) {
                IModelElement child = element.read((ElementProperty)property).element();
                if (child == null) continue;
                out.writeByte(1);
                out.writeUTF(property.getName());
                this.javaToNative(child, out);
                continue;
            }
            if (!(property instanceof ListProperty) || (list = element.read((ListProperty)property)).isEmpty()) continue;
            out.writeByte(1);
            out.writeUTF(property.getName());
            this.javaToNative((List<IModelElement>)list, out);
        }
        out.writeByte(0);
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            ListFactory elementsListFactory = ListFactory.start();
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                String qualifiedTypeName = in.readUTF();
                ModelElementType type = ModelElementType.read((ClassLoader)this.classLoader, (String)qualifiedTypeName);
                IModelElement element = type.instantiate();
                this.nativeToJava(in, element);
                elementsListFactory.add((Object)element);
                ++i;
            }
            return elementsListFactory.result();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void nativeToJava(DataInputStream in, IModelElement element) throws IOException {
        while (in.readByte() != 0) {
            String propertyName = in.readUTF();
            ModelProperty property = element.property(propertyName);
            if (property instanceof ValueProperty) {
                String value = in.readUTF();
                element.write(property, (Object)value);
                continue;
            }
            if (property instanceof ImpliedElementProperty) {
                in.readUTF();
                IModelElement child = element.read((ElementProperty)((ImpliedElementProperty)property)).element();
                this.nativeToJava(in, child);
                continue;
            }
            if (property instanceof ElementProperty) {
                String qualifiedTypeName = in.readUTF();
                ModelElementType type = ModelElementType.read((ClassLoader)this.classLoader, (String)qualifiedTypeName);
                IModelElement child = element.read((ElementProperty)property).element(true, type);
                this.nativeToJava(in, child);
                continue;
            }
            if (!(property instanceof ListProperty)) continue;
            ModelElementList list = element.read((ListProperty)property);
            int size = in.readInt();
            int i = 0;
            while (i < size) {
                String qualifiedTypeName = in.readUTF();
                ModelElementType type = ModelElementType.read((ClassLoader)this.classLoader, (String)qualifiedTypeName);
                IModelElement child = list.insert(type);
                this.nativeToJava(in, child);
                ++i;
            }
        }
    }
}

