/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnabledFunction
extends Function {
    public static EnabledFunction create(List<Function> operands) {
        EnabledFunction function = new EnabledFunction();
        function.init(operands);
        return function;
    }

    public static EnabledFunction create(Function element, Function property) {
        EnabledFunction function = new EnabledFunction();
        function.init(element, property);
        return function;
    }

    public static EnabledFunction create(Function element, String property) {
        return EnabledFunction.create(element, Literal.create(property));
    }

    public static EnabledFunction create(Function property) {
        EnabledFunction function = new EnabledFunction();
        function.init(property);
        return function;
    }

    public static EnabledFunction create(String property) {
        return EnabledFunction.create(Literal.create(property));
    }

    @Override
    public String name() {
        return "Enabled";
    }

    @Override
    public FunctionResult evaluate(final FunctionContext context) {
        return new FunctionResult(this, context){
            private IModelElement lastElement;
            private ModelProperty lastProperty;
            private Listener listener;

            protected Object evaluate() {
                ModelProperty property;
                IModelElement element;
                block16: {
                    Boolean bl;
                    block17: {
                        block18: {
                            block19: {
                                element = null;
                                property = null;
                                try {
                                    int count = this.operands().size();
                                    String propertyName = null;
                                    if (count == 1) {
                                        if (!(context instanceof ModelElementFunctionContext)) {
                                            throw new FunctionException(Resources.contextElementNotFound);
                                        }
                                        element = ((ModelElementFunctionContext)context).element();
                                        propertyName = this.cast(this.operand(0).value(), String.class);
                                    } else if (count == 2) {
                                        element = this.cast(this.operand(0).value(), IModelElement.class);
                                        propertyName = this.cast(this.operand(1).value(), String.class);
                                    } else {
                                        String msg = NLS.bind(Resources.wrongNumberOfArguments, count);
                                        throw new FunctionException(msg);
                                    }
                                    if (element == null || propertyName.length() <= 0 || (property = (ModelProperty)element.type().property(propertyName)) == null) break block16;
                                    bl = element.enabled(property);
                                    if (this.lastElement == element && this.lastProperty == property) break block17;
                                    if (this.lastElement != null && this.lastProperty != null) {
                                        this.lastElement.detach(this.listener, this.lastProperty);
                                    }
                                    if (element == null || property == null) break block18;
                                    if (this.listener != null) break block19;
                                }
                                catch (Throwable throwable) {
                                    if (this.lastElement != element || this.lastProperty != property) {
                                        if (this.lastElement != null && this.lastProperty != null) {
                                            this.lastElement.detach(this.listener, this.lastProperty);
                                        }
                                        if (element != null && property != null) {
                                            if (this.listener == null) {
                                                this.listener = new FilteredListener<PropertyEnablementEvent>(){

                                                    @Override
                                                    protected void handleTypedEvent(PropertyEnablementEvent event) {
                                                        this.refresh();
                                                    }
                                                };
                                            }
                                            element.attach(this.listener, property);
                                        }
                                        this.lastElement = element;
                                        this.lastProperty = property;
                                    }
                                    throw throwable;
                                }
                                this.listener = new /* invalid duplicate definition of identical inner class */;
                            }
                            element.attach(this.listener, property);
                        }
                        this.lastElement = element;
                        this.lastProperty = property;
                    }
                    return bl;
                }
                if (this.lastElement != element || this.lastProperty != property) {
                    if (this.lastElement != null && this.lastProperty != null) {
                        this.lastElement.detach(this.listener, this.lastProperty);
                    }
                    if (element != null && property != null) {
                        if (this.listener == null) {
                            this.listener = new /* invalid duplicate definition of identical inner class */;
                        }
                        element.attach(this.listener, property);
                    }
                    this.lastElement = element;
                    this.lastProperty = property;
                }
                return null;
            }
        };
    }

    private static final class Resources
    extends NLS {
        public static String wrongNumberOfArguments;
        public static String contextElementNotFound;

        static {
            Resources.initializeMessages(EnabledFunction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

