/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.ValidationService;

public abstract class PathValidationService
extends ValidationService {
    protected boolean resourceMustExist;
    protected FileSystemResourceType validResourceType;
    private FileExtensionsService fileExtensionsService;

    protected void init() {
        super.init();
        IModelElement element = this.context(IModelElement.class);
        ModelProperty property = this.context(ModelProperty.class);
        this.resourceMustExist = property.hasAnnotation(MustExist.class);
        ValidFileSystemResourceType validResourceTypeAnnotation = property.getAnnotation(ValidFileSystemResourceType.class);
        this.validResourceType = validResourceTypeAnnotation != null ? validResourceTypeAnnotation.value() : null;
        this.fileExtensionsService = element.service(property, FileExtensionsService.class);
        if (this.fileExtensionsService != null) {
            this.fileExtensionsService.attach(new Listener(){

                public void handle(Event event) {
                    PathValidationService.this.broadcast();
                }
            });
        }
    }

    protected final Status validateExtensions(Path path) {
        String fileName;
        if (this.fileExtensionsService != null && (fileName = path.lastSegment()) != null) {
            int count;
            List<String> extensions = this.fileExtensionsService.extensions();
            int n = count = extensions == null ? 0 : extensions.size();
            if (count > 0) {
                String trimmedFileName = fileName.trim();
                int lastdot = trimmedFileName.lastIndexOf(46);
                String extension = lastdot == -1 ? "" : trimmedFileName.substring(lastdot + 1);
                boolean match = false;
                if (extension != null && extension.length() != 0) {
                    for (String ext : extensions) {
                        if (!extension.equalsIgnoreCase(ext)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match) {
                    String message;
                    if (count == 1) {
                        message = NLS.bind(Resources.invalidFileExtensionOne, trimmedFileName, extensions.get(0));
                    } else if (count == 2) {
                        message = NLS.bind(Resources.invalidFileExtensionTwo, trimmedFileName, extensions.get(0), extensions.get(1));
                    } else {
                        StringBuilder buf = new StringBuilder();
                        for (String ext : extensions) {
                            if (buf.length() != 0) {
                                buf.append(", ");
                            }
                            buf.append(ext);
                        }
                        message = NLS.bind(Resources.invalidFileExtensionMultiple, trimmedFileName, buf.toString());
                    }
                    return Status.createErrorStatus(message);
                }
            }
        }
        return Status.createOkStatus();
    }

    protected static final class Resources
    extends NLS {
        public static String folderMustExist;
        public static String fileMustExist;
        public static String resourceMustExist;
        public static String pathIsNotFile;
        public static String pathIsNotFolder;
        public static String invalidFileExtensionOne;
        public static String invalidFileExtensionTwo;
        public static String invalidFileExtensionMultiple;

        static {
            Resources.initializeMessages(PathValidationService.class.getName(), Resources.class);
        }

        protected Resources() {
        }
    }
}

