/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.util.ListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version
implements Comparable<Version> {
    private final List<Long> segments;
    private final int length;

    public Version(long version) {
        if (version == 0L) {
            this.segments = Collections.emptyList();
            this.length = 0;
        } else if (version > 0L) {
            this.segments = Collections.singletonList(version);
            this.length = 1;
        } else {
            throw new IllegalArgumentException(String.valueOf(version));
        }
    }

    public Version(String versionString) throws IllegalArgumentException {
        if (versionString == null) {
            throw new IllegalArgumentException();
        }
        String str = versionString.trim();
        if (str.startsWith(".") || str.endsWith(".") || str.contains("..")) {
            throw new IllegalArgumentException(str);
        }
        ListFactory<Long> segments = ListFactory.start();
        String[] stringArray = str.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            long segmentAsLong;
            String segment = stringArray[n2];
            try {
                segmentAsLong = Long.parseLong(segment);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(str);
            }
            if (segmentAsLong < 0L) {
                throw new IllegalArgumentException(str);
            }
            segments.add(segmentAsLong);
            ++n2;
        }
        int i = segments.size() - 1;
        while (i >= 0) {
            if ((Long)segments.get(i) != 0L) break;
            segments.remove(i);
            --i;
        }
        this.segments = segments.result();
        this.length = this.segments.size();
    }

    public List<Long> segments() {
        return this.segments;
    }

    public long segment(int position) {
        if (position < 0) {
            throw new IllegalArgumentException(String.valueOf(position));
        }
        if (position < this.length) {
            return this.segments.get(position);
        }
        return 0L;
    }

    public int length() {
        return this.length;
    }

    public boolean matches(String constraint) {
        return this.matches(new VersionConstraint(constraint));
    }

    public boolean matches(VersionConstraint constraint) {
        return constraint.check(this);
    }

    @Override
    public int compareTo(Version version) {
        int i = 0;
        int n = Math.max(this.length(), version.length);
        while (i < n) {
            long res = this.segment(i) - version.segment(i);
            if (res > 0L) {
                return 1;
            }
            if (res < 0L) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version version = (Version)obj;
            if (this.length() == version.length()) {
                int i = 0;
                int n = this.length();
                while (i < n) {
                    if (this.segment(i) != version.segment(i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        int i = 0;
        int n = this.length();
        while (i < n) {
            hashCode = (int)((long)hashCode * this.segment(i));
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (long segment : this.segments) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(segment);
        }
        return buf.toString();
    }
}

