/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.List;
import java.util.SortedSet;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListFromValuePossibleValuesService
extends PossibleValuesService {
    private PossibleValuesService base;
    private Listener listener;
    private boolean broadcasting;

    @Override
    protected void init() {
        super.init();
        ListProperty listProperty = this.context(ListProperty.class);
        ValueProperty listMemberValueProperty = (ValueProperty)listProperty.getType().properties().get(0);
        this.base = listMemberValueProperty.service(PossibleValuesService.class);
        this.listener = new Listener(){

            public void handle(Event event) {
                if (!ListFromValuePossibleValuesService.this.broadcasting) {
                    try {
                        ListFromValuePossibleValuesService.this.broadcasting = true;
                        ListFromValuePossibleValuesService.this.broadcast();
                    }
                    finally {
                        ListFromValuePossibleValuesService.this.broadcasting = false;
                    }
                }
            }
        };
        this.base.attach(this.listener);
    }

    @Override
    protected void fillPossibleValues(SortedSet<String> values) {
        values.addAll(this.base.values());
    }

    @Override
    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        return this.base.getInvalidValueSeverity(invalidValue);
    }

    @Override
    public String getInvalidValueMessage(String invalidValue) {
        return this.base.getInvalidValueMessage(invalidValue);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.base.isCaseSensitive();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.base.detach(this.listener);
            this.listener = null;
        }
        this.base = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ModelProperty memberProperty;
            ModelElementType memberType;
            List<ModelProperty> properties;
            IModelElement element;
            ListProperty listProperty = context.find(ListProperty.class);
            return listProperty != null && (element = context.find(IModelElement.class)).service(listProperty, PossibleTypesService.class).types().size() == 1 && (properties = (memberType = listProperty.getType()).properties()).size() == 1 && (memberProperty = properties.get(0)) instanceof ValueProperty && memberProperty.service(PossibleValuesService.class) != null;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new ListFromValuePossibleValuesService();
        }
    }
}

