/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.MasterVersionCompatibilityService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EnablementServiceData;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class VersionCompatibilityEnablementService
extends EnablementService {
    private MasterVersionCompatibilityService versionCompatibilityService;
    private Listener versionCompatibilityServiceListener;
    private Listener propertyListener;

    protected void initEnablementService() {
        IModelElement element = this.context(IModelElement.class);
        ModelProperty property = this.context(ModelProperty.class);
        this.versionCompatibilityService = element.service(property, MasterVersionCompatibilityService.class);
        this.versionCompatibilityServiceListener = new Listener(){

            public void handle(Event event) {
                VersionCompatibilityEnablementService.this.refresh();
            }
        };
        this.versionCompatibilityService.attach(this.versionCompatibilityServiceListener);
        this.propertyListener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                VersionCompatibilityEnablementService.this.refresh();
            }
        };
        if (property instanceof ImpliedElementProperty) {
            element.attach(this.propertyListener, String.valueOf(property.getName()) + "/*");
        } else {
            element.attach(this.propertyListener, property.getName());
        }
    }

    protected EnablementServiceData compute() {
        IModelElement element = this.context(IModelElement.class);
        ModelProperty property = this.context(ModelProperty.class);
        return new EnablementServiceData(this.versionCompatibilityService.compatible() || !element.empty(property));
    }

    public void dispose() {
        super.dispose();
        IModelElement element = this.context(IModelElement.class);
        ModelProperty property = this.context(ModelProperty.class);
        this.versionCompatibilityService.detach(this.versionCompatibilityServiceListener);
        if (property instanceof ImpliedElementProperty) {
            element.detach(this.propertyListener, String.valueOf(property.getName()) + "/*");
        } else {
            element.detach(this.propertyListener, property.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            return true;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new VersionCompatibilityEnablementService();
        }
    }
}

