/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.t0005;

import java.util.List;
import javax.xml.namespace.QName;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModelReference;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlGroupContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0005.TestXmlXsd0005Circle;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0005.TestXmlXsd0005Rectangle;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0005.TestXmlXsd0005Workbook;

public final class TestXmlXsd0005
extends SapphireTestCase {
    private static final String NAMESPACE = "http://www.eclipse.org/sapphire/tests/xml/xsd/0005/workbook";

    private TestXmlXsd0005(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("TestXmlXsd0005");
        suite.addTest((Test)new TestXmlXsd0005("testSchemaParsing"));
        suite.addTest((Test)new TestXmlXsd0005("testInsertOrder"));
        return suite;
    }

    public void testSchemaParsing() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema((String)NAMESPACE);
        XmlElementDefinition workbookElementDef = schema.getElement("workbook");
        XmlSequenceGroup workbookContentModel = (XmlSequenceGroup)workbookElementDef.getContentModel();
        List workbookNestedContent = workbookContentModel.getNestedContent();
        TestXmlXsd0005.assertEquals((int)1, (int)workbookNestedContent.size());
        XmlContentModelReference shapesGroupRef = (XmlContentModelReference)workbookNestedContent.get(0);
        XmlGroupContentModel shapesGroup = (XmlGroupContentModel)shapesGroupRef.getContentModel();
        List shapesGroupNestedContent = shapesGroup.getNestedContent();
        TestXmlXsd0005.assertEquals((int)2, (int)shapesGroupNestedContent.size());
        XmlElementDefinition circleElementDef = (XmlElementDefinition)shapesGroupNestedContent.get(0);
        XmlSequenceGroup circleContentModel = (XmlSequenceGroup)circleElementDef.getContentModel();
        List circleNestedContent = circleContentModel.getNestedContent();
        TestXmlXsd0005.assertEquals((String)"circle", (String)circleElementDef.getName().getLocalPart());
        TestXmlXsd0005.assertEquals((int)3, (int)circleNestedContent.size());
        TestXmlXsd0005.assertEquals((String)"x", (String)((XmlElementDefinition)circleNestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((String)"y", (String)((XmlElementDefinition)circleNestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((String)"radius", (String)((XmlElementDefinition)circleNestedContent.get(2)).getName().getLocalPart());
        XmlElementDefinition rectangleElementDef = (XmlElementDefinition)shapesGroupNestedContent.get(1);
        XmlSequenceGroup rectangleContentModel = (XmlSequenceGroup)rectangleElementDef.getContentModel();
        List rectangleNestedContent = rectangleContentModel.getNestedContent();
        TestXmlXsd0005.assertEquals((String)"rectangle", (String)rectangleElementDef.getName().getLocalPart());
        TestXmlXsd0005.assertEquals((int)4, (int)rectangleNestedContent.size());
        TestXmlXsd0005.assertEquals((String)"x", (String)((XmlElementDefinition)rectangleNestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((String)"y", (String)((XmlElementDefinition)rectangleNestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((String)"width", (String)((XmlElementDefinition)rectangleNestedContent.get(2)).getName().getLocalPart());
        TestXmlXsd0005.assertEquals((String)"height", (String)((XmlElementDefinition)rectangleNestedContent.get(3)).getName().getLocalPart());
        XmlContentModel foundCircleContentModel = workbookContentModel.findChildElementContentModel(new QName(NAMESPACE, "circle"));
        TestXmlXsd0005.assertNotNull((Object)foundCircleContentModel);
        XmlContentModel foundRectangleContentModel = workbookContentModel.findChildElementContentModel(new QName(NAMESPACE, "rectangle"));
        TestXmlXsd0005.assertNotNull((Object)foundRectangleContentModel);
    }

    public void testInsertOrder() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        TestXmlXsd0005Workbook workbook = (TestXmlXsd0005Workbook)TestXmlXsd0005Workbook.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(resourceStore)));
        TestXmlXsd0005Circle circle = (TestXmlXsd0005Circle)workbook.getShapes().insert(TestXmlXsd0005Circle.class);
        circle.setRadius(3);
        circle.setY(2);
        circle.setX(1);
        TestXmlXsd0005Rectangle rectangle = (TestXmlXsd0005Rectangle)workbook.getShapes().insert(TestXmlXsd0005Rectangle.class);
        rectangle.setHeight(4);
        rectangle.setWidth(3);
        rectangle.setY(2);
        rectangle.setX(1);
        workbook.resource().save();
        String result = new String(resourceStore.getContents(), "UTF-8");
        TestXmlXsd0005.assertEqualsIgnoreNewLineDiffs(this.loadResource("ExpectedInsertionOrder.txt"), result);
    }
}

