/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;

public class LabelNodeCommand
extends Command {
    private DiagramNodeModel node;
    private String labelText;

    public LabelNodeCommand(DiagramNodeModel node, String labelText) {
        this.node = node;
        this.labelText = labelText;
    }

    public void execute() {
        DiagramModel diagramModel = this.node.getDiagramModel();
        List<DiagramConnectionModel> connModels = diagramModel.getConnections();
        ArrayList<DiagramConnectionPart> connParts1 = new ArrayList<DiagramConnectionPart>();
        ArrayList<DiagramConnectionPart> connParts2 = new ArrayList<DiagramConnectionPart>();
        for (DiagramConnectionModel connModel : connModels) {
            if (!connModel.getSourceNode().equals(this.node) && !connModel.getTargetNode().equals(this.node)) continue;
            DiagramConnectionPart connPart = connModel.getModelPart();
            connPart.removeModelListener();
            connPart.getDiagramConnectionTemplate().removeModelListener();
            if (connModel.getSourceNode().equals(this.node)) {
                connParts1.add(connModel.getModelPart());
                continue;
            }
            if (!connModel.getTargetNode().equals(this.node)) continue;
            connParts2.add(connModel.getModelPart());
        }
        this.node.getModelPart().setLabel(this.labelText);
        for (DiagramConnectionPart connPart : connParts1) {
            if (connPart.disposed()) continue;
            connPart.resetEndpoint1();
            connPart.addModelListener();
            connPart.getDiagramConnectionTemplate().addModelListener();
        }
        for (DiagramConnectionPart connPart : connParts2) {
            if (connPart.disposed()) continue;
            connPart.resetEndpoint2();
            connPart.addModelListener();
            connPart.getDiagramConnectionTemplate().addModelListener();
        }
    }
}

