/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.sapphire.FileName;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.workspace.CreateWorkspaceFileOp;
import org.eclipse.sapphire.workspace.WorkspaceFileType;

public final class CreateWorkspaceFileOpMethods {
    public static IFile getFileHandle(CreateWorkspaceFileOp operation) {
        Path folderPath = (Path)operation.getFolder().getContent();
        FileName fileName = (FileName)operation.getFileName().getContent();
        if (folderPath == null || fileName == null) {
            return null;
        }
        Path newFilePath = folderPath.append(fileName.toString());
        return ResourcesPlugin.getWorkspace().getRoot().getFile(PathBridge.create((Path)newFilePath));
    }

    public static Status execute(CreateWorkspaceFileOp operation, ProgressMonitor monitor) {
        block14: {
            if (monitor == null) {
                monitor = new ProgressMonitor();
            }
            monitor.beginTask(Resources.executeTaskName, 2);
            try {
                ModelElementType type;
                Resource resource;
                IFile newFileHandle = operation.getFileHandle();
                try {
                    newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    CreateWorkspaceFileOpMethods.create(newFileHandle.getParent());
                    if (newFileHandle.exists()) {
                        newFileHandle.setContents((InputStream)new ByteArrayInputStream(new byte[0]), 1, null);
                    } else {
                        newFileHandle.create((InputStream)new ByteArrayInputStream(new byte[0]), 1, null);
                    }
                }
                catch (CoreException e) {
                    Status status = StatusBridge.create((IStatus)e.getStatus());
                    monitor.done();
                    return status;
                }
                monitor.worked(1);
                WorkspaceFileType fileTypeAnnotation = (WorkspaceFileType)operation.type().getAnnotation(WorkspaceFileType.class);
                if (fileTypeAnnotation == null || (resource = (Resource)((MasterConversionService)(type = ModelElementType.read(fileTypeAnnotation.value())).service(MasterConversionService.class)).convert((Object)newFileHandle, Resource.class)) == null) break block14;
                try {
                    IModelElement element = type.instantiate(resource);
                    try {
                        element.initialize();
                        resource.save();
                    }
                    finally {
                        element.dispose();
                    }
                }
                catch (ResourceStoreException e) {
                    Status status = Status.createErrorStatus((Throwable)e);
                    monitor.done();
                    return status;
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.createOkStatus();
    }

    private static void create(IContainer container) throws CoreException {
        if (!container.exists()) {
            CreateWorkspaceFileOpMethods.create(container.getParent());
            IFolder iFolder = (IFolder)container;
            iFolder.create(true, true, null);
        }
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;

        static {
            Resources.initializeMessages((String)CreateWorkspaceFileOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

