/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PreferDefaultValue;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.modeling.util.internal.SapphireCommonUtil;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

public final class PreferDefaultValueValidationService
extends ValidationService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            @Override
            protected void handleTypedEvent(PropertyContentEvent event) {
                PreferDefaultValueValidationService.this.broadcast();
            }
        };
        this.context(IModelElement.class).attach(this.listener, this.context(ValueProperty.class));
    }

    public Status validate() {
        ValueProperty property;
        IModelElement element = this.context(IModelElement.class);
        Value value = element.read(property = this.context(ValueProperty.class));
        if (!value.isDefault()) {
            String text = value.getText();
            String def = SapphireCommonUtil.getDefaultValueLabel(element, property);
            if (def != null && !def.equals(text)) {
                String message = NLS.bind(Resources.message, property.getLabel(true, CapitalizationType.FIRST_WORD_ONLY, false), def);
                return Status.createWarningStatus(message);
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.context(IModelElement.class).detach(this.listener, this.context(ValueProperty.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            if (property != null) {
                return property.hasAnnotation(PreferDefaultValue.class);
            }
            return false;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new PreferDefaultValueValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String message;

        static {
            Resources.initializeMessages(PreferDefaultValueValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

