/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.MasterVersionCompatibilityService;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.ValidationService;

public abstract class VersionCompatibilityValidationService
extends ValidationService {
    private MasterVersionCompatibilityService versionCompatibilityService;
    private Listener versionCompatibilityServiceListener;

    protected void init() {
        super.init();
        this.versionCompatibilityService = this.element().service(this.property(), MasterVersionCompatibilityService.class);
        this.versionCompatibilityServiceListener = new Listener(){

            public void handle(Event event) {
                VersionCompatibilityValidationService.this.broadcast();
            }
        };
        this.versionCompatibilityService.attach(this.versionCompatibilityServiceListener);
    }

    protected abstract IModelElement element();

    protected abstract ModelProperty property();

    protected boolean problem() {
        return !this.versionCompatibilityService.compatible();
    }

    public Status validate() {
        if (this.problem()) {
            Version version = this.versionCompatibilityService.version();
            String versioned = this.versionCompatibilityService.versioned();
            String message = version == null ? Resources.versionConstraintTargetNotFoundMessage : Resources.bind(Resources.notCompatibleWithVersionMessage, version.toString(), versioned);
            return Status.createErrorStatus(message);
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        super.dispose();
        if (this.versionCompatibilityService != null) {
            this.versionCompatibilityService.detach(this.versionCompatibilityServiceListener);
        }
    }

    private static final class Resources
    extends NLS {
        public static String notCompatibleWithVersionMessage;
        public static String versionConstraintTargetNotFoundMessage;

        static {
            Resources.initializeMessages(VersionCompatibilityValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

