/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.services.ImageService;

public final class ImageFunction
extends Function {
    public static ImageFunction create() {
        ImageFunction function = new ImageFunction();
        function.init(new Function[0]);
        return function;
    }

    public String name() {
        return "Image";
    }

    public FunctionResult evaluate(final FunctionContext context) {
        return new FunctionResult(this, context){
            private ImageService imageService;
            private Listener imageServiceListener;

            protected void init() {
                List<FunctionResult> operands = this.operands();
                IModelElement element = operands.isEmpty() ? ((ModelElementFunctionContext)context).element() : this.cast(this.operand(0).value(), IModelElement.class);
                this.imageService = element.service(ImageService.class);
                if (this.imageService != null) {
                    this.imageServiceListener = new Listener(){

                        public void handle(Event event) {
                            this.refresh();
                        }
                    };
                    this.imageService.attach(this.imageServiceListener);
                }
            }

            protected Object evaluate() {
                if (this.imageService == null) {
                    return null;
                }
                return this.imageService.image();
            }

            public void dispose() {
                super.dispose();
                if (this.imageService != null) {
                    this.imageService.detach(this.imageServiceListener);
                    this.imageService = null;
                    this.imageServiceListener = null;
                }
            }
        };
    }
}

