/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CountConstraintFactsService
extends FactsService {
    @Override
    protected void facts(SortedSet<String> facts) {
        CountConstraint constraint = this.context(ModelProperty.class).getAnnotation(CountConstraint.class);
        int min = constraint.min();
        int max = constraint.max();
        if (min == 1) {
            facts.add(Resources.atLeastOneStatement);
        } else if (min > 1) {
            facts.add(NLS.bind(Resources.minCountStatement, min));
        }
        if (max < Integer.MAX_VALUE) {
            facts.add(NLS.bind(Resources.maxCountStatement, max));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ListProperty property = context.find(ListProperty.class);
            if (property != null) {
                CountConstraint constraint = property.getAnnotation(CountConstraint.class);
                return constraint != null && (constraint.min() > 0 || constraint.max() < Integer.MAX_VALUE);
            }
            return false;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new CountConstraintFactsService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String atLeastOneStatement;
        public static String minCountStatement;
        public static String maxCountStatement;

        static {
            Resources.initializeMessages(CountConstraintFactsService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

